/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.util.NoSuchElementException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocol;
import org.neo4j.bolt.testing.BoltTestUtil;
import org.neo4j.bolt.transport.BoltProtocolFactory;
import org.neo4j.bolt.transport.pipeline.ProtocolHandshaker;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;

public class ProtocolHandshakerTest {
    private final BoltChannel boltChannel = ProtocolHandshakerTest.newBoltChannel();
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @After
    public void tearDown() throws Exception {
        this.boltChannel.close();
    }

    @Test
    public void shouldChooseFirstAvailableProtocol() {
        BoltProtocol protocol = ProtocolHandshakerTest.newBoltProtocol(1L);
        BoltProtocolFactory handlerFactory = ProtocolHandshakerTest.newProtocolFactory(1L, protocol);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, this.boltChannel, (LogProvider)this.logProvider, false, true)});
        ByteBuf input = Unpooled.wrappedBuffer((byte[][])new byte[][]{{96, 96, -80, 23}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}});
        channel.writeInbound(new Object[]{input});
        Assert.assertEquals((long)1L, (long)channel.outboundMessages().size());
        BoltTestUtil.assertByteBufEquals(Unpooled.buffer().writeInt(1), (ByteBuf)channel.readOutbound());
        this.thrown.expect(NoSuchElementException.class);
        channel.pipeline().remove(ProtocolHandshaker.class);
        Assert.assertTrue((boolean)channel.isActive());
        ((BoltProtocol)Mockito.verify((Object)protocol)).install();
    }

    @Test
    public void shouldHandleFragmentedMessage() {
        BoltProtocol protocol = ProtocolHandshakerTest.newBoltProtocol(1L);
        BoltProtocolFactory handlerFactory = ProtocolHandshakerTest.newProtocolFactory(1L, protocol);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, this.boltChannel, (LogProvider)this.logProvider, false, true)});
        channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{96, 96, -80})});
        Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
        channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{23, 0, 0, 0})});
        Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
        channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 0, 0})});
        Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
        channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 0, 0, 0})});
        Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
        channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 0, 0})});
        Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
        channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 0})});
        Assert.assertEquals((long)1L, (long)channel.outboundMessages().size());
        BoltTestUtil.assertByteBufEquals(Unpooled.buffer().writeInt(1), (ByteBuf)channel.readOutbound());
        this.thrown.expect(NoSuchElementException.class);
        channel.pipeline().remove(ProtocolHandshaker.class);
        Assert.assertTrue((boolean)channel.isActive());
        ((BoltProtocol)Mockito.verify((Object)protocol)).install();
    }

    @Test
    public void shouldHandleHandshakeFollowedImmediatelyByMessage() {
        BoltProtocol protocol = ProtocolHandshakerTest.newBoltProtocol(1L);
        BoltProtocolFactory handlerFactory = ProtocolHandshakerTest.newProtocolFactory(1L, protocol);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, this.boltChannel, (LogProvider)this.logProvider, false, true)});
        ByteBuf input = Unpooled.wrappedBuffer((byte[][])new byte[][]{{96, 96, -80, 23}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 2, 3, 4}});
        channel.writeInbound(new Object[]{input});
        Assert.assertEquals((long)1L, (long)channel.outboundMessages().size());
        BoltTestUtil.assertByteBufEquals(Unpooled.buffer().writeInt(1), (ByteBuf)channel.readOutbound());
        Assert.assertEquals((long)1L, (long)channel.inboundMessages().size());
        BoltTestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}), (ByteBuf)channel.readInbound());
        this.thrown.expect(NoSuchElementException.class);
        channel.pipeline().remove(ProtocolHandshaker.class);
        Assert.assertTrue((boolean)channel.isActive());
        ((BoltProtocol)Mockito.verify((Object)protocol)).install();
    }

    @Test
    public void shouldHandleMaxVersionNumber() {
        long maxVersionNumber = 0xFFFFFFFFL;
        BoltProtocol protocol = ProtocolHandshakerTest.newBoltProtocol(maxVersionNumber);
        BoltProtocolFactory handlerFactory = ProtocolHandshakerTest.newProtocolFactory(maxVersionNumber, protocol);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, this.boltChannel, (LogProvider)this.logProvider, false, true)});
        ByteBuf input = Unpooled.wrappedBuffer((byte[][])new byte[][]{{96, 96, -80, 23}, {-1, -1, -1, -1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}});
        channel.writeInbound(new Object[]{input});
        Assert.assertEquals((long)1L, (long)channel.outboundMessages().size());
        BoltTestUtil.assertByteBufEquals(Unpooled.buffer().writeInt((int)maxVersionNumber), (ByteBuf)channel.readOutbound());
        this.thrown.expect(NoSuchElementException.class);
        channel.pipeline().remove(ProtocolHandshaker.class);
        Assert.assertTrue((boolean)channel.isActive());
        ((BoltProtocol)Mockito.verify((Object)protocol)).install();
    }

    @Test
    public void shouldFallbackToNoProtocolIfNoMatch() {
        BoltProtocol protocol = ProtocolHandshakerTest.newBoltProtocol(1L);
        BoltProtocolFactory handlerFactory = ProtocolHandshakerTest.newProtocolFactory(1L, protocol);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, this.boltChannel, (LogProvider)this.logProvider, false, true)});
        ByteBuf input = Unpooled.wrappedBuffer((byte[][])new byte[][]{{96, 96, -80, 23}, {0, 0, 0, 0}, {0, 0, 0, 2}, {0, 0, 0, 3}, {0, 0, 0, 4}});
        channel.writeInbound(new Object[]{input});
        Assert.assertEquals((long)1L, (long)channel.outboundMessages().size());
        BoltTestUtil.assertByteBufEquals(Unpooled.buffer().writeInt(0), (ByteBuf)channel.readOutbound());
        Assert.assertFalse((boolean)channel.isActive());
        ((BoltProtocol)Mockito.verify((Object)protocol, (VerificationMode)Mockito.never())).install();
    }

    @Test
    public void shouldRejectIfWrongPreamble() {
        BoltProtocol protocol = ProtocolHandshakerTest.newBoltProtocol(1L);
        BoltProtocolFactory handlerFactory = ProtocolHandshakerTest.newProtocolFactory(1L, protocol);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, this.boltChannel, (LogProvider)this.logProvider, false, true)});
        ByteBuf input = Unpooled.wrappedBuffer((byte[][])new byte[][]{{-34, -85, -51, -17}, {0, 0, 0, 1}, {0, 0, 0, 2}, {0, 0, 0, 3}, {0, 0, 0, 4}});
        channel.writeInbound(new Object[]{input});
        Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
        Assert.assertFalse((boolean)channel.isActive());
        ((BoltProtocol)Mockito.verify((Object)protocol, (VerificationMode)Mockito.never())).install();
    }

    @Test
    public void shouldRejectIfInsecureWhenEncryptionRequired() {
        BoltProtocol protocol = ProtocolHandshakerTest.newBoltProtocol(1L);
        BoltProtocolFactory handlerFactory = ProtocolHandshakerTest.newProtocolFactory(1L, protocol);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, this.boltChannel, (LogProvider)this.logProvider, true, false)});
        ByteBuf input = Unpooled.wrappedBuffer((byte[][])new byte[][]{{96, 96, -80, 23}, {0, 0, 0, 1}, {0, 0, 0, 2}, {0, 0, 0, 3}, {0, 0, 0, 4}});
        channel.writeInbound(new Object[]{input});
        Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
        Assert.assertFalse((boolean)channel.isActive());
        ((BoltProtocol)Mockito.verify((Object)protocol, (VerificationMode)Mockito.never())).install();
    }

    @Test
    public void shouldRejectIfHttp() {
        BoltProtocol protocol = ProtocolHandshakerTest.newBoltProtocol(1L);
        BoltProtocolFactory handlerFactory = ProtocolHandshakerTest.newProtocolFactory(1L, protocol);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, this.boltChannel, (LogProvider)this.logProvider, false, true)});
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://hello_world:10000");
        request.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
        channel.writeInbound(new Object[]{request});
        Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
        Assert.assertFalse((boolean)channel.isActive());
        ((BoltProtocol)Mockito.verify((Object)protocol, (VerificationMode)Mockito.never())).install();
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(ProtocolHandshaker.class).warn("Unsupported connection type: 'HTTP'. Bolt protocol only operates over a TCP connection or WebSocket.")});
    }

    private static BoltChannel newBoltChannel() {
        return new BoltChannel("bolt-1", "bolt", (Channel)new EmbeddedChannel());
    }

    private static BoltProtocol newBoltProtocol(long version) {
        BoltProtocol handler = (BoltProtocol)Mockito.mock(BoltProtocol.class);
        Mockito.when((Object)handler.version()).thenReturn((Object)version);
        return handler;
    }

    private static BoltProtocolFactory newProtocolFactory(long version, BoltProtocol protocol) {
        return (givenVersion, channel) -> version == givenVersion ? protocol : null;
    }
}

