/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.bolt.runtime.SynchronousBoltConnection;
import org.neo4j.bolt.transport.pipeline.MessageDecoder;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageReaderV1;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v1.messaging.example.Edges;
import org.neo4j.bolt.v1.messaging.example.Nodes;
import org.neo4j.bolt.v1.messaging.example.Paths;
import org.neo4j.bolt.v1.messaging.request.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackedOutputArray;
import org.neo4j.bolt.v2.messaging.Neo4jPackV2;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.VirtualValues;

@RunWith(value=Parameterized.class)
public class MessageDecoderTest {
    private EmbeddedChannel channel;
    @Parameterized.Parameter(value=0)
    public Neo4jPack packerUnderTest;
    @Parameterized.Parameter(value=1)
    public String name;

    @Parameterized.Parameters(name="{1}")
    public static Object[][] testParameters() {
        return new Object[][]{{new Neo4jPackV1(), "V1"}, {new Neo4jPackV2(), "V2"}};
    }

    @After
    public void cleanup() {
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
        }
    }

    @Test
    public void shouldDispatchInit() throws Exception {
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        SynchronousBoltConnection connection = new SynchronousBoltConnection(stateMachine);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{this.newDecoder(connection)});
        String userAgent = "Test/User Agent 1.0";
        Map authToken = MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "user", "credentials", "password"});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(this.packerUnderTest, new RequestMessage[]{new InitMessage(userAgent, authToken)}))});
        this.channel.finishAndReleaseAll();
        ((BoltStateMachine)Mockito.verify((Object)stateMachine)).process((RequestMessage)ArgumentMatchers.refEq((Object)new InitMessage(userAgent, authToken), (String[])new String[]{"authToken"}), (BoltResponseHandler)ArgumentMatchers.any());
    }

    @Test
    public void shouldDispatchAckFailure() throws Exception {
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        SynchronousBoltConnection connection = new SynchronousBoltConnection(stateMachine);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{this.newDecoder(connection)});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(this.packerUnderTest, new RequestMessage[]{AckFailureMessage.INSTANCE}))});
        this.channel.finishAndReleaseAll();
        ((BoltStateMachine)Mockito.verify((Object)stateMachine)).process((RequestMessage)ArgumentMatchers.eq((Object)AckFailureMessage.INSTANCE), (BoltResponseHandler)ArgumentMatchers.any());
    }

    @Test
    public void shouldDispatchReset() throws Exception {
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        SynchronousBoltConnection connection = new SynchronousBoltConnection(stateMachine);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{this.newDecoder(connection)});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(this.packerUnderTest, new RequestMessage[]{ResetMessage.INSTANCE}))});
        this.channel.finishAndReleaseAll();
        ((BoltStateMachine)Mockito.verify((Object)stateMachine)).process((RequestMessage)ArgumentMatchers.eq((Object)ResetMessage.INSTANCE), (BoltResponseHandler)ArgumentMatchers.any());
    }

    @Test
    public void shouldDispatchRun() throws Exception {
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        SynchronousBoltConnection connection = new SynchronousBoltConnection(stateMachine);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{this.newDecoder(connection)});
        String statement = "RETURN 1";
        MapValue parameters = ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"param1", 1, "param2", "2", "param3", true, "param4", 5.0}));
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(this.packerUnderTest, new RequestMessage[]{new RunMessage(statement, parameters)}))});
        this.channel.finishAndReleaseAll();
        ((BoltStateMachine)Mockito.verify((Object)stateMachine)).process((RequestMessage)ArgumentMatchers.eq((Object)new RunMessage(statement, parameters)), (BoltResponseHandler)ArgumentMatchers.any());
    }

    @Test
    public void shouldDispatchDiscardAll() throws Exception {
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        SynchronousBoltConnection connection = new SynchronousBoltConnection(stateMachine);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{this.newDecoder(connection)});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(this.packerUnderTest, new RequestMessage[]{DiscardAllMessage.INSTANCE}))});
        this.channel.finishAndReleaseAll();
        ((BoltStateMachine)Mockito.verify((Object)stateMachine)).process((RequestMessage)ArgumentMatchers.eq((Object)DiscardAllMessage.INSTANCE), (BoltResponseHandler)ArgumentMatchers.any());
    }

    @Test
    public void shouldDispatchPullAll() throws Exception {
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        SynchronousBoltConnection connection = new SynchronousBoltConnection(stateMachine);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{this.newDecoder(connection)});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(this.packerUnderTest, new RequestMessage[]{PullAllMessage.INSTANCE}))});
        this.channel.finishAndReleaseAll();
        ((BoltStateMachine)Mockito.verify((Object)stateMachine)).process((RequestMessage)ArgumentMatchers.eq((Object)PullAllMessage.INSTANCE), (BoltResponseHandler)ArgumentMatchers.any());
    }

    @Test
    public void shouldCallExternalErrorOnInitWithNullKeys() throws Exception {
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        SynchronousBoltConnection connection = new SynchronousBoltConnection(stateMachine);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{this.newDecoder(connection)});
        String userAgent = "Test/User Agent 1.0";
        Map authToken = MapUtil.map((Object[])new Object[]{"scheme", "basic", null, "user", "credentials", "password"});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(this.packerUnderTest, new RequestMessage[]{new InitMessage(userAgent, authToken)}))});
        this.channel.finishAndReleaseAll();
        ((BoltStateMachine)Mockito.verify((Object)stateMachine)).handleExternalFailure((Neo4jError)ArgumentMatchers.eq((Object)Neo4jError.from((Status)Status.Request.Invalid, (String)"Value `null` is not supported as key in maps, must be a non-nullable string.")), (BoltResponseHandler)ArgumentMatchers.any());
    }

    @Test
    public void shouldCallExternalErrorOnInitWithDuplicateKeys() throws Exception {
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        SynchronousBoltConnection connection = new SynchronousBoltConnection(stateMachine);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{this.newDecoder(connection)});
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.packerUnderTest.newPacker((PackOutput)out);
        packer.packStructHeader(2, (byte)1);
        packer.pack("Test/User Agent 1.0");
        packer.packMapHeader(3);
        packer.pack("scheme");
        packer.pack("basic");
        packer.pack("principal");
        packer.pack("user");
        packer.pack("scheme");
        packer.pack("password");
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])out.bytes())});
        this.channel.finishAndReleaseAll();
        ((BoltStateMachine)Mockito.verify((Object)stateMachine)).handleExternalFailure((Neo4jError)ArgumentMatchers.eq((Object)Neo4jError.from((Status)Status.Request.Invalid, (String)"Duplicate map key `scheme`.")), (BoltResponseHandler)ArgumentMatchers.any());
    }

    @Test
    public void shouldCallExternalErrorOnNodeParameter() throws Exception {
        this.testUnpackableStructParametersWithKnownType((AnyValue)Nodes.ALICE, "Node values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnRelationshipParameter() throws Exception {
        this.testUnpackableStructParametersWithKnownType((AnyValue)Edges.ALICE_KNOWS_BOB, "Relationship values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnPathParameter() throws Exception {
        for (PathValue path : Paths.ALL_PATHS) {
            this.testUnpackableStructParametersWithKnownType((AnyValue)path, "Path values cannot be unpacked with this version of bolt.");
        }
    }

    @Test
    public void shouldCallExternalErrorOnDuration() throws Exception {
        Assume.assumeThat((Object)this.packerUnderTest.version(), (Matcher)Matchers.equalTo((Object)1L));
        this.testUnpackableStructParametersWithKnownType((Neo4jPack)new Neo4jPackV2(), (AnyValue)Values.durationValue((TemporalAmount)Duration.ofDays(10L)), "Duration values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnDate() throws Exception {
        Assume.assumeThat((Object)this.packerUnderTest.version(), (Matcher)Matchers.equalTo((Object)1L));
        this.testUnpackableStructParametersWithKnownType((Neo4jPack)new Neo4jPackV2(), ValueUtils.of((Object)LocalDate.now()), "LocalDate values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnLocalTime() throws Exception {
        Assume.assumeThat((Object)this.packerUnderTest.version(), (Matcher)Matchers.equalTo((Object)1L));
        this.testUnpackableStructParametersWithKnownType((Neo4jPack)new Neo4jPackV2(), ValueUtils.of((Object)LocalTime.now()), "LocalTime values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnTime() throws Exception {
        Assume.assumeThat((Object)this.packerUnderTest.version(), (Matcher)Matchers.equalTo((Object)1L));
        this.testUnpackableStructParametersWithKnownType((Neo4jPack)new Neo4jPackV2(), ValueUtils.of((Object)OffsetTime.now()), "OffsetTime values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnLocalDateTime() throws Exception {
        Assume.assumeThat((Object)this.packerUnderTest.version(), (Matcher)Matchers.equalTo((Object)1L));
        this.testUnpackableStructParametersWithKnownType((Neo4jPack)new Neo4jPackV2(), ValueUtils.of((Object)LocalDateTime.now()), "LocalDateTime values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnDateTimeWithOffset() throws Exception {
        Assume.assumeThat((Object)this.packerUnderTest.version(), (Matcher)Matchers.equalTo((Object)1L));
        this.testUnpackableStructParametersWithKnownType((Neo4jPack)new Neo4jPackV2(), ValueUtils.of((Object)OffsetDateTime.now()), "OffsetDateTime values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnDateTimeWithZoneName() throws Exception {
        Assume.assumeThat((Object)this.packerUnderTest.version(), (Matcher)Matchers.equalTo((Object)1L));
        this.testUnpackableStructParametersWithKnownType((Neo4jPack)new Neo4jPackV2(), ValueUtils.of((Object)ZonedDateTime.now()), "ZonedDateTime values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldThrowOnUnknownStructType() throws Exception {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.packerUnderTest.newPacker((PackOutput)out);
        packer.packStructHeader(2, (byte)16);
        packer.pack("RETURN $x");
        packer.packMapHeader(1);
        packer.pack("x");
        packer.packStructHeader(0, (byte)65);
        try {
            this.unpack(out.bytes());
        }
        catch (BoltIOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.equalTo((Object)"Struct types of 0x41 are not recognized."));
        }
    }

    @Test
    public void shouldLogContentOfTheMessageOnIOError() throws Exception {
        BoltConnection connection = (BoltConnection)Mockito.mock(BoltConnection.class);
        BoltResponseMessageWriter responseMessageHandler = (BoltResponseMessageWriter)Mockito.mock(BoltResponseMessageWriter.class);
        BoltRequestMessageReaderV1 requestMessageReader = new BoltRequestMessageReaderV1(connection, responseMessageHandler, (LogService)NullLogService.getInstance());
        LogService logService = (LogService)Mockito.mock(LogService.class);
        Log log = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)logService.getInternalLog(MessageDecoder.class)).thenReturn((Object)log);
        ChannelHandler[] channelHandlerArray = new ChannelHandler[1];
        channelHandlerArray[0] = new MessageDecoder(arg_0 -> ((Neo4jPack)this.packerUnderTest).newUnpacker(arg_0), (BoltRequestMessageReader)requestMessageReader, logService);
        this.channel = new EmbeddedChannel(channelHandlerArray);
        byte invalidMessageSignature = 127;
        byte[] messageBytes = this.packMessageWithSignature(invalidMessageSignature);
        try {
            this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])messageBytes)});
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        MessageDecoderTest.assertMessageHexDumpLogged(log, messageBytes);
    }

    @Test
    public void shouldLogContentOfTheMessageOnError() throws Exception {
        BoltRequestMessageReader requestMessageReader = (BoltRequestMessageReader)Mockito.mock(BoltRequestMessageReader.class);
        RuntimeException error = new RuntimeException("Hello!");
        ((BoltRequestMessageReader)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)requestMessageReader)).read((Neo4jPack.Unpacker)ArgumentMatchers.any());
        LogService logService = (LogService)Mockito.mock(LogService.class);
        Log log = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)logService.getInternalLog(MessageDecoder.class)).thenReturn((Object)log);
        ChannelHandler[] channelHandlerArray = new ChannelHandler[1];
        channelHandlerArray[0] = new MessageDecoder(arg_0 -> ((Neo4jPack)this.packerUnderTest).newUnpacker(arg_0), requestMessageReader, logService);
        this.channel = new EmbeddedChannel(channelHandlerArray);
        byte[] messageBytes = this.packMessageWithSignature((byte)16);
        try {
            this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])messageBytes)});
            Assert.fail((String)"Exception expected");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)error, (Object)e);
        }
        MessageDecoderTest.assertMessageHexDumpLogged(log, messageBytes);
    }

    private void testUnpackableStructParametersWithKnownType(AnyValue parameterValue, String expectedMessage) throws Exception {
        this.testUnpackableStructParametersWithKnownType(this.packerUnderTest, parameterValue, expectedMessage);
    }

    private void testUnpackableStructParametersWithKnownType(Neo4jPack packerForSerialization, AnyValue parameterValue, String expectedMessage) throws Exception {
        String statement = "RETURN $x";
        MapValue parameters = VirtualValues.map((String[])new String[]{"x"}, (AnyValue[])new AnyValue[]{parameterValue});
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        SynchronousBoltConnection connection = new SynchronousBoltConnection(stateMachine);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{this.newDecoder(connection)});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(packerForSerialization, new RequestMessage[]{new RunMessage(statement, parameters)}))});
        this.channel.finishAndReleaseAll();
        ((BoltStateMachine)Mockito.verify((Object)stateMachine)).handleExternalFailure((Neo4jError)ArgumentMatchers.eq((Object)Neo4jError.from((Status)Status.Statement.TypeError, (String)expectedMessage)), (BoltResponseHandler)ArgumentMatchers.any());
    }

    private void unpack(byte[] input) throws IOException {
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        SynchronousBoltConnection connection = new SynchronousBoltConnection(stateMachine);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{this.newDecoder(connection)});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])input)});
        this.channel.finishAndReleaseAll();
    }

    private byte[] packMessageWithSignature(byte signature) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.packerUnderTest.newPacker((PackOutput)out);
        packer.packStructHeader(2, signature);
        packer.pack("RETURN 'Hello World!'");
        packer.pack((AnyValue)VirtualValues.EMPTY_MAP);
        return out.bytes();
    }

    private MessageDecoder newDecoder(BoltConnection connection) {
        BoltRequestMessageReaderV1 reader = new BoltRequestMessageReaderV1(connection, (BoltResponseMessageWriter)Mockito.mock(BoltResponseMessageWriter.class), (LogService)NullLogService.getInstance());
        return new MessageDecoder(arg_0 -> ((Neo4jPack)this.packerUnderTest).newUnpacker(arg_0), (BoltRequestMessageReader)reader, (LogService)NullLogService.getInstance());
    }

    private static void assertMessageHexDumpLogged(Log logMock, byte[] messageBytes) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((Log)Mockito.verify((Object)logMock)).error((String)captor.capture());
        Assert.assertThat((Object)captor.getValue(), (Matcher)Matchers.containsString((String)ByteBufUtil.hexDump((byte[])messageBytes)));
    }
}

