/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.bolt.testing.BoltTestUtil;
import org.neo4j.bolt.transport.pipeline.MessageAccumulator;

public class MessageAccumulatorTest {
    private final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new MessageAccumulator()});

    @After
    public void cleanup() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    public void shouldDecodeMessageWithSingleChunk() {
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5})}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[0])}));
        Assert.assertTrue((boolean)this.channel.finish());
        Assert.assertEquals((long)1L, (long)this.channel.inboundMessages().size());
        BoltTestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5}), (ByteBuf)this.channel.readInbound());
    }

    @Test
    public void shouldDecodeMessageWithMultipleChunks() {
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3})}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{4, 5})}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{6, 7, 8})}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[0])}));
        Assert.assertTrue((boolean)this.channel.finish());
        Assert.assertEquals((long)1L, (long)this.channel.inboundMessages().size());
        BoltTestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8}), (ByteBuf)this.channel.readInbound());
    }

    @Test
    public void shouldDecodeMultipleConsecutiveMessages() {
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3})});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[0])});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{4, 5})});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{6})});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[0])});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{7, 8})});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{9, 10})});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[0])});
        Assert.assertEquals((long)3L, (long)this.channel.inboundMessages().size());
        BoltTestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), (ByteBuf)this.channel.readInbound());
        BoltTestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[]{4, 5, 6}), (ByteBuf)this.channel.readInbound());
        BoltTestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[]{7, 8, 9, 10}), (ByteBuf)this.channel.readInbound());
    }
}

