/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.transport.pipeline.HouseKeeper;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.logging.internal.SimpleLogService;

public class HouseKeeperTest {
    private EmbeddedChannel channel;

    @After
    public void cleanup() {
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
        }
    }

    @Test
    public void shouldStopConnectionOnChannelInactive() {
        BoltConnection connection = (BoltConnection)Mockito.mock(BoltConnection.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new HouseKeeper(connection, (LogService)NullLogService.getInstance())});
        this.channel.pipeline().fireChannelInactive();
        ((BoltConnection)Mockito.verify((Object)connection)).stop();
    }

    @Test
    public void shouldNotPropagateChannelInactive() throws Exception {
        ChannelInboundHandler next = (ChannelInboundHandler)Mockito.mock(ChannelInboundHandler.class);
        BoltConnection connection = (BoltConnection)Mockito.mock(BoltConnection.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new HouseKeeper(connection, (LogService)NullLogService.getInstance()), next});
        this.channel.pipeline().fireChannelInactive();
        ((ChannelInboundHandler)Mockito.verify((Object)next, (VerificationMode)Mockito.never())).channelInactive((ChannelHandlerContext)ArgumentMatchers.any());
    }

    @Test
    public void shouldStopConnectionOnExceptionCaught() {
        BoltConnection connection = (BoltConnection)Mockito.mock(BoltConnection.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new HouseKeeper(connection, (LogService)NullLogService.getInstance())});
        this.channel.pipeline().fireExceptionCaught((Throwable)new RuntimeException("some exception"));
        ((BoltConnection)Mockito.verify((Object)connection)).stop();
    }

    @Test
    public void shouldLogExceptionOnExceptionCaught() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        BoltConnection connection = (BoltConnection)Mockito.mock(BoltConnection.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new HouseKeeper(connection, (LogService)new SimpleLogService((LogProvider)logProvider))});
        RuntimeException exception = new RuntimeException("some exception");
        this.channel.pipeline().fireExceptionCaught((Throwable)exception);
        ((BoltConnection)Mockito.verify((Object)connection)).stop();
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(HouseKeeper.class).error(Matchers.startsWith((String)"Fatal error occurred when handling a client connection"), Matchers.equalTo((Object)exception))});
    }

    @Test
    public void shouldNotPropagateExceptionCaught() throws Exception {
        ChannelInboundHandler next = (ChannelInboundHandler)Mockito.mock(ChannelInboundHandler.class);
        BoltConnection connection = (BoltConnection)Mockito.mock(BoltConnection.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new HouseKeeper(connection, (LogService)NullLogService.getInstance()), next});
        this.channel.pipeline().fireExceptionCaught((Throwable)new RuntimeException("some exception"));
        ((ChannelInboundHandler)Mockito.verify((Object)next, (VerificationMode)Mockito.never())).exceptionCaught((ChannelHandlerContext)ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any());
    }
}

