/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.bolt.testing.BoltTestUtil;
import org.neo4j.bolt.transport.pipeline.ChunkDecoder;

public class ChunkDecoderTest {
    private final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChunkDecoder()});

    @After
    public void cleanup() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    public void shouldDecodeFullChunk() {
        ByteBuf input = Unpooled.buffer();
        input.writeShort(7);
        input.writeByte(1);
        input.writeByte(11);
        input.writeByte(2);
        input.writeByte(22);
        input.writeByte(3);
        input.writeByte(33);
        input.writeByte(4);
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{input}));
        Assert.assertTrue((boolean)this.channel.finish());
        Assert.assertEquals((long)1L, (long)this.channel.inboundMessages().size());
        BoltTestUtil.assertByteBufEquals(input.slice(2, 7), (ByteBuf)this.channel.readInbound());
    }

    @Test
    public void shouldDecodeSplitChunk() {
        ByteBuf input1 = Unpooled.buffer();
        input1.writeShort(9);
        input1.writeByte(1);
        input1.writeByte(11);
        input1.writeByte(2);
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{input1}));
        ByteBuf input2 = Unpooled.buffer();
        input2.writeByte(22);
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{input2}));
        ByteBuf input3 = Unpooled.buffer();
        input3.writeByte(3);
        input3.writeByte(33);
        input3.writeByte(4);
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{input3}));
        ByteBuf input4 = Unpooled.buffer();
        input4.writeByte(44);
        input4.writeByte(5);
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{input4}));
        Assert.assertTrue((boolean)this.channel.finish());
        Assert.assertEquals((long)1L, (long)this.channel.inboundMessages().size());
        BoltTestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[]{1, 11, 2, 22, 3, 33, 4, 44, 5}), (ByteBuf)this.channel.readInbound());
    }

    @Test
    public void shouldDecodeEmptyChunk() {
        ByteBuf input = Unpooled.copyShort((int)0);
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{input}));
        Assert.assertTrue((boolean)this.channel.finish());
        Assert.assertEquals((long)1L, (long)this.channel.inboundMessages().size());
        BoltTestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[0]), (ByteBuf)this.channel.readInbound());
    }

    @Test
    public void shouldDecodeMaxSizeChunk() {
        byte[] message = new byte[65535];
        ByteBuf input = Unpooled.buffer();
        input.writeShort(message.length);
        input.writeBytes(message);
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{input}));
        Assert.assertTrue((boolean)this.channel.finish());
        Assert.assertEquals((long)1L, (long)this.channel.inboundMessages().size());
        BoltTestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])message), (ByteBuf)this.channel.readInbound());
    }
}

