/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.transport.BoltProtocolFactory;
import org.neo4j.bolt.transport.SocketTransport;
import org.neo4j.bolt.transport.TransportSelectionHandler;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

class SocketTransportTest {
    SocketTransportTest() {
    }

    @Test
    void shouldManageChannelsInChannelInitializer() {
        NetworkConnectionTracker connectionTracker = (NetworkConnectionTracker)Mockito.mock(NetworkConnectionTracker.class);
        SocketTransport socketTransport = SocketTransportTest.newSocketTransport(connectionTracker, TransportThrottleGroup.NO_THROTTLE);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{socketTransport.channelInitializer()});
        ArgumentCaptor captor = ArgumentCaptor.forClass(TrackedNetworkConnection.class);
        ((NetworkConnectionTracker)Mockito.verify((Object)connectionTracker)).add((TrackedNetworkConnection)captor.capture());
        ((NetworkConnectionTracker)Mockito.verify((Object)connectionTracker, (VerificationMode)Mockito.never())).remove((TrackedNetworkConnection)ArgumentMatchers.any());
        channel.close();
        ((NetworkConnectionTracker)Mockito.verify((Object)connectionTracker)).remove((TrackedNetworkConnection)captor.getValue());
    }

    @Test
    void shouldManageThrottlersInChannelInitializer() {
        TransportThrottleGroup throttleGroup = (TransportThrottleGroup)Mockito.mock(TransportThrottleGroup.class);
        SocketTransport socketTransport = SocketTransportTest.newSocketTransport(NetworkConnectionTracker.NO_OP, throttleGroup);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{socketTransport.channelInitializer()});
        ((TransportThrottleGroup)Mockito.verify((Object)throttleGroup)).install((Channel)channel);
        ((TransportThrottleGroup)Mockito.verify((Object)throttleGroup, (VerificationMode)Mockito.never())).uninstall((Channel)channel);
        channel.close();
        ((TransportThrottleGroup)Mockito.verify((Object)throttleGroup)).uninstall((Channel)channel);
    }

    @Test
    void shouldInstallTransportSelectionHandler() {
        SocketTransport socketTransport = SocketTransportTest.newSocketTransport(NetworkConnectionTracker.NO_OP, TransportThrottleGroup.NO_THROTTLE);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{socketTransport.channelInitializer()});
        TransportSelectionHandler handler = (TransportSelectionHandler)channel.pipeline().get(TransportSelectionHandler.class);
        Assertions.assertNotNull((Object)handler);
    }

    private static SocketTransport newSocketTransport(NetworkConnectionTracker connectionTracker, TransportThrottleGroup throttleGroup) {
        return new SocketTransport("bolt", new ListenSocketAddress("localhost", 7687), null, false, (LogProvider)NullLogProvider.getInstance(), throttleGroup, (BoltProtocolFactory)Mockito.mock(BoltProtocolFactory.class), connectionTracker);
    }
}

