/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocol;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.BoltStateMachineFactory;
import org.neo4j.bolt.testing.BoltTestUtil;
import org.neo4j.bolt.transport.DefaultBoltProtocolFactory;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;

class DefaultBoltProtocolFactoryTest {
    DefaultBoltProtocolFactoryTest() {
    }

    @Test
    void shouldCreateNothingForUnknownProtocolVersion() {
        int protocolVersion = 42;
        BoltChannel channel = BoltTestUtil.newTestBoltChannel();
        DefaultBoltProtocolFactory factory = new DefaultBoltProtocolFactory((BoltConnectionFactory)Mockito.mock(BoltConnectionFactory.class), (BoltStateMachineFactory)Mockito.mock(BoltStateMachineFactory.class), (LogService)NullLogService.getInstance());
        BoltProtocol protocol = factory.create((long)protocolVersion, channel);
        Assert.assertNull((Object)protocol);
    }

    @ParameterizedTest(name="V{0}")
    @ValueSource(longs={1L, 2L, 3L})
    void shouldCreateBoltProtocol(long protocolVersion) throws Throwable {
        EmbeddedChannel channel = new EmbeddedChannel();
        BoltChannel boltChannel = new BoltChannel("bolt-1", "bolt", (Channel)channel);
        BoltStateMachineFactory stateMachineFactory = (BoltStateMachineFactory)Mockito.mock(BoltStateMachineFactory.class);
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        Mockito.when((Object)stateMachineFactory.newStateMachine(protocolVersion, boltChannel)).thenReturn((Object)stateMachine);
        BoltConnectionFactory connectionFactory = (BoltConnectionFactory)Mockito.mock(BoltConnectionFactory.class);
        BoltConnection connection = (BoltConnection)Mockito.mock(BoltConnection.class);
        Mockito.when((Object)connectionFactory.newConnection(boltChannel, stateMachine)).thenReturn((Object)connection);
        DefaultBoltProtocolFactory factory = new DefaultBoltProtocolFactory(connectionFactory, stateMachineFactory, (LogService)NullLogService.getInstance());
        BoltProtocol protocol = factory.create(protocolVersion, boltChannel);
        protocol.install();
        Assert.assertEquals((long)protocolVersion, (long)protocol.version());
        ((BoltConnectionFactory)Mockito.verify((Object)connectionFactory)).newConnection((BoltChannel)ArgumentMatchers.eq((Object)boltChannel), (BoltStateMachine)ArgumentMatchers.any(BoltStateMachine.class));
        ((BoltConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).stop();
        channel.close();
        ((BoltConnection)Mockito.verify((Object)connection)).stop();
        channel.finishAndReleaseAll();
    }
}

