/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.testing;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.Assert;
import org.neo4j.bolt.BoltChannel;

public class BoltTestUtil {
    public static BoltChannel newTestBoltChannel() {
        return BoltTestUtil.newTestBoltChannel("bolt-1");
    }

    public static BoltChannel newTestBoltChannel(String id) {
        return new BoltChannel(id, "bolt", (Channel)new EmbeddedChannel());
    }

    public static void assertByteBufEquals(ByteBuf expected, ByteBuf actual) {
        try {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        finally {
            BoltTestUtil.releaseIfPossible(expected);
            BoltTestUtil.releaseIfPossible(actual);
        }
    }

    private static void releaseIfPossible(ByteBuf buf) {
        if (buf.refCnt() > 0) {
            buf.release();
        }
    }
}

