/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.security.auth;

import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.security.auth.BasicAuthentication;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.string.UTF8;
import org.neo4j.time.Clocks;

public class BasicAuthenticationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private Authentication authentication;

    @Test
    public void shouldNotDoAnythingOnSuccess() throws Exception {
        AuthenticationResult result = this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "mike", "credentials", UTF8.encode((String)"secret2")}));
        MatcherAssert.assertThat((Object)result.getLoginContext().subject().username(), (Matcher)CoreMatchers.equalTo((Object)"mike"));
    }

    @Test
    public void shouldThrowAndLogOnFailure() throws Exception {
        this.exception.expect(AuthenticationException.class);
        this.exception.expect((Matcher)this.hasStatus((Status)Status.Security.Unauthorized));
        this.exception.expectMessage("The client is unauthorized due to authentication failure.");
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "bob", "credentials", UTF8.encode((String)"banana")}));
    }

    @Test
    public void shouldIndicateThatCredentialsExpired() throws Exception {
        AuthenticationResult result = this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "bob", "credentials", UTF8.encode((String)"secret")}));
        Assert.assertTrue((boolean)result.credentialsExpired());
    }

    @Test
    public void shouldFailWhenTooManyAttempts() throws Exception {
        int maxFailedAttempts = ThreadLocalRandom.current().nextInt(1, 10);
        Authentication auth = BasicAuthenticationTest.createAuthentication(maxFailedAttempts);
        for (int i = 0; i < maxFailedAttempts; ++i) {
            try {
                auth.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "bob", "credentials", UTF8.encode((String)"gelato")}));
                continue;
            }
            catch (AuthenticationException e) {
                MatcherAssert.assertThat((Object)e.status(), (Matcher)CoreMatchers.equalTo((Object)Status.Security.Unauthorized));
            }
        }
        this.exception.expect(AuthenticationException.class);
        this.exception.expect((Matcher)this.hasStatus((Status)Status.Security.AuthenticationRateLimit));
        this.exception.expectMessage("The client has provided incorrect authentication details too many times in a row.");
        auth.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "bob", "credentials", UTF8.encode((String)"gelato")}));
    }

    @Test
    public void shouldBeAbleToUpdateCredentials() throws Exception {
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "mike", "credentials", UTF8.encode((String)"secret2"), "new_credentials", UTF8.encode((String)"secret")}));
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "mike", "credentials", UTF8.encode((String)"secret")}));
    }

    @Test
    public void shouldClearCredentialsAfterUse() throws Exception {
        byte[] oldPassword = UTF8.encode((String)"secret2");
        byte[] newPassword1 = UTF8.encode((String)"secret");
        byte[] newPassword2 = UTF8.encode((String)"secret");
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "mike", "credentials", oldPassword, "new_credentials", newPassword1}));
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "mike", "credentials", newPassword2}));
        MatcherAssert.assertThat((Object)oldPassword, (Matcher)BasicAuthenticationTest.isCleared());
        MatcherAssert.assertThat((Object)newPassword1, (Matcher)BasicAuthenticationTest.isCleared());
        MatcherAssert.assertThat((Object)newPassword2, (Matcher)BasicAuthenticationTest.isCleared());
    }

    @Test
    public void shouldBeAbleToUpdateExpiredCredentials() throws Exception {
        AuthenticationResult result = this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "bob", "credentials", UTF8.encode((String)"secret"), "new_credentials", UTF8.encode((String)"secret2")}));
        MatcherAssert.assertThat((Object)result.credentialsExpired(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldNotBeAbleToUpdateCredentialsIfOldCredentialsAreInvalid() throws Exception {
        this.exception.expect(AuthenticationException.class);
        this.exception.expect((Matcher)this.hasStatus((Status)Status.Security.Unauthorized));
        this.exception.expectMessage("The client is unauthorized due to authentication failure.");
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "bob", "credentials", UTF8.encode((String)"gelato"), "new_credentials", UTF8.encode((String)"secret2")}));
    }

    @Test
    public void shouldThrowWithNoScheme() throws Exception {
        this.exception.expect(AuthenticationException.class);
        this.exception.expect((Matcher)this.hasStatus((Status)Status.Security.Unauthorized));
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"principal", "bob", "credentials", UTF8.encode((String)"secret")}));
    }

    @Test
    public void shouldFailOnInvalidAuthToken() throws Exception {
        this.exception.expect(AuthenticationException.class);
        this.exception.expect((Matcher)this.hasStatus((Status)Status.Security.Unauthorized));
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"this", "does", "not", "matter", "for", "test"}));
    }

    @Test
    public void shouldFailOnMalformedToken() throws Exception {
        this.exception.expect(AuthenticationException.class);
        this.exception.expect((Matcher)this.hasStatus((Status)Status.Security.Unauthorized));
        this.exception.expectMessage("Unsupported authentication token, the value associated with the key `principal` must be a String but was: SingletonList");
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", Collections.singletonList("bob"), "credentials", UTF8.encode((String)"secret")}));
    }

    @Before
    public void setup() throws Throwable {
        this.authentication = BasicAuthenticationTest.createAuthentication(3);
    }

    private static Authentication createAuthentication(int maxFailedAttempts) throws Exception {
        InMemoryUserRepository users = new InMemoryUserRepository();
        PasswordPolicy policy = (PasswordPolicy)Mockito.mock(PasswordPolicy.class);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.auth_max_failed_attempts, (String)String.valueOf(maxFailedAttempts));
        BasicAuthManager manager = new BasicAuthManager((UserRepository)users, policy, Clocks.systemClock(), (UserRepository)users, config);
        BasicAuthentication authentication = new BasicAuthentication((AuthManager)manager, (UserManagerSupplier)manager);
        manager.newUser("bob", UTF8.encode((String)"secret"), true);
        manager.newUser("mike", UTF8.encode((String)"secret2"), false);
        return authentication;
    }

    private HasStatus hasStatus(Status status) {
        return new HasStatus(status);
    }

    static CredentialsClearedMatcher isCleared() {
        return new CredentialsClearedMatcher();
    }

    static class CredentialsClearedMatcher
    extends BaseMatcher<byte[]> {
        CredentialsClearedMatcher() {
        }

        public boolean matches(Object o) {
            if (o instanceof byte[]) {
                byte[] bytes = (byte[])o;
                for (int i = 0; i < bytes.length; ++i) {
                    if (bytes[i] == 0) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("Byte array should contain only zeroes");
        }
    }

    static class HasStatus
    extends TypeSafeMatcher<Status.HasStatus> {
        private Status status;

        HasStatus(Status status) {
            this.status = status;
        }

        protected boolean matchesSafely(Status.HasStatus item) {
            return item.status() == this.status;
        }

        public void describeTo(Description description) {
            description.appendText("expects status ").appendValue((Object)this.status);
        }

        protected void describeMismatchSafely(Status.HasStatus item, Description mismatchDescription) {
            mismatchDescription.appendText("was ").appendValue((Object)item.status());
        }
    }
}

