/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.security.auth;

import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Test;
import org.neo4j.helpers.collection.MapUtil;

public abstract class AuthTokenDecoderTest {
    private static Object[] valuesWithInvalidTypes = new Object[]{new char[]{'p', 'a', 's', 's'}, Collections.emptyList(), Collections.emptyMap()};

    protected abstract void testShouldDecodeAuthToken(Map<String, Object> var1) throws Exception;

    protected abstract void testShouldFailToDecodeAuthToken(Map<String, Object> var1, String var2) throws Exception;

    @Test
    void shouldDecodeAuthTokenWithStringCredentials() throws Exception {
        this.testShouldDecodeAuthToken(AuthTokenDecoderTest.authTokenMapWith("credentials", "password"));
    }

    @Test
    void shouldDecodeAuthTokenWithEmptyStringCredentials() throws Exception {
        this.testShouldDecodeAuthToken(AuthTokenDecoderTest.authTokenMapWith("credentials", ""));
    }

    @Test
    void shouldDecodeAuthTokenWithNullCredentials() throws Exception {
        this.testShouldDecodeAuthToken(AuthTokenDecoderTest.authTokenMapWith("credentials", null));
    }

    @Test
    void shouldDecodeAuthTokenWithStringNewCredentials() throws Exception {
        this.testShouldDecodeAuthToken(AuthTokenDecoderTest.authTokenMapWith("new_credentials", "password"));
    }

    @Test
    void shouldDecodeAuthTokenWithEmptyStringNewCredentials() throws Exception {
        this.testShouldDecodeAuthToken(AuthTokenDecoderTest.authTokenMapWith("new_credentials", ""));
    }

    @Test
    void shouldDecodeAuthTokenWithNullNewCredentials() throws Exception {
        this.testShouldDecodeAuthToken(AuthTokenDecoderTest.authTokenMapWith("new_credentials", null));
    }

    @Test
    void shouldFailToDecodeAuthTokenWithCredentialsOfUnsupportedTypes() throws Exception {
        for (Object value : valuesWithInvalidTypes) {
            this.testShouldFailToDecodeAuthToken(AuthTokenDecoderTest.authTokenMapWith("credentials", value), "INIT message authentication token field 'credentials' should be a UTF-8 encoded string");
        }
    }

    @Test
    void shouldFailToDecodeAuthTokenWithNewCredentialsOfUnsupportedType() throws Exception {
        for (Object value : valuesWithInvalidTypes) {
            this.testShouldFailToDecodeAuthToken(AuthTokenDecoderTest.authTokenMapWith("new_credentials", value), "INIT message authentication token field 'new_credentials' should be a UTF-8 encoded string");
        }
    }

    private static Map<String, Object> authTokenMapWith(String fieldName, Object fieldValue) {
        return MapUtil.map((Object[])new Object[]{"principal", "neo4j", fieldName, fieldValue});
    }
}

