/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.exceptions.Status;

public class Neo4jErrorTest {
    @Test
    public void shouldAssignUnknownStatusToUnpredictedException() {
        Throwable cause = new Throwable("This is not an error we know how to handle.");
        Neo4jError error = Neo4jError.from((Throwable)cause);
        MatcherAssert.assertThat((Object)error.status(), (Matcher)CoreMatchers.equalTo((Object)Status.General.UnknownError));
    }

    @Test
    public void shouldConvertDeadlockException() {
        Neo4jError error = Neo4jError.from((Throwable)new DeadlockDetectedException(null));
        Assert.assertEquals((Object)Status.Transaction.DeadlockDetected, (Object)error.status());
    }

    @Test
    public void shouldSetStatusToDatabaseUnavailableOnDatabaseShutdownException() {
        DatabaseShutdownException ex = new DatabaseShutdownException();
        Neo4jError error = Neo4jError.from((Throwable)ex);
        MatcherAssert.assertThat((Object)error.status(), (Matcher)CoreMatchers.equalTo((Object)Status.General.DatabaseUnavailable));
        MatcherAssert.assertThat((Object)error.cause(), (Matcher)CoreMatchers.equalTo((Object)ex));
    }
}

