/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.MutableConnectionState;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

class MutableConnectionStateTest {
    private final MutableConnectionState state = new MutableConnectionState();
    private final BoltResult result = (BoltResult)Mockito.mock(BoltResult.class);
    private final BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);

    MutableConnectionStateTest() {
    }

    @Test
    void shouldHandleOnRecordsWithoutResponseHandler() throws Exception {
        this.state.setResponseHandler(null);
        this.state.onRecords(this.result, true);
        Assertions.assertNull((Object)this.state.getPendingError());
        Assertions.assertFalse((boolean)this.state.hasPendingIgnore());
    }

    @Test
    void shouldHandleOnRecordsWitResponseHandler() throws Exception {
        this.state.setResponseHandler(this.responseHandler);
        this.state.onRecords(this.result, true);
        ((BoltResponseHandler)Mockito.verify((Object)this.responseHandler)).onRecords(this.result, true);
    }

    @Test
    void shouldHandleOnMetadataWithoutResponseHandler() {
        this.state.setResponseHandler(null);
        this.state.onMetadata("key", (AnyValue)Values.stringValue((String)"value"));
        Assertions.assertNull((Object)this.state.getPendingError());
        Assertions.assertFalse((boolean)this.state.hasPendingIgnore());
    }

    @Test
    void shouldHandleOnMetadataWitResponseHandler() {
        this.state.setResponseHandler(this.responseHandler);
        this.state.onMetadata("key", (AnyValue)Values.stringValue((String)"value"));
        ((BoltResponseHandler)Mockito.verify((Object)this.responseHandler)).onMetadata("key", (AnyValue)Values.stringValue((String)"value"));
    }

    @Test
    void shouldHandleMarkIgnoredWithoutResponseHandler() {
        this.state.setResponseHandler(null);
        this.state.markIgnored();
        Assertions.assertNull((Object)this.state.getPendingError());
        Assertions.assertTrue((boolean)this.state.hasPendingIgnore());
    }

    @Test
    void shouldHandleMarkIgnoredWitResponseHandler() {
        this.state.setResponseHandler(this.responseHandler);
        this.state.markIgnored();
        ((BoltResponseHandler)Mockito.verify((Object)this.responseHandler)).markIgnored();
        Assertions.assertNull((Object)this.state.getPendingError());
        Assertions.assertFalse((boolean)this.state.hasPendingIgnore());
    }

    @Test
    void shouldHandleMarkFailedWithoutResponseHandler() {
        this.state.setResponseHandler(null);
        Neo4jError error = Neo4jError.from((Throwable)new RuntimeException());
        this.state.markFailed(error);
        Assertions.assertEquals((Object)error, (Object)this.state.getPendingError());
        Assertions.assertFalse((boolean)this.state.hasPendingIgnore());
    }

    @Test
    void shouldHandleMarkFailedWitResponseHandler() {
        this.state.setResponseHandler(this.responseHandler);
        Neo4jError error = Neo4jError.from((Throwable)new RuntimeException());
        this.state.markFailed(error);
        ((BoltResponseHandler)Mockito.verify((Object)this.responseHandler)).markFailed(error);
        Assertions.assertNull((Object)this.state.getPendingError());
        Assertions.assertFalse((boolean)this.state.hasPendingIgnore());
    }

    @Test
    void shouldHandleOnFinishWithoutResponseHandler() {
        this.state.setResponseHandler(null);
        this.state.onFinish();
        Assertions.assertNull((Object)this.state.getPendingError());
        Assertions.assertFalse((boolean)this.state.hasPendingIgnore());
    }

    @Test
    void shouldHandleOnFinishWitResponseHandler() {
        this.state.setResponseHandler(this.responseHandler);
        this.state.onFinish();
        ((BoltResponseHandler)Mockito.verify((Object)this.responseHandler)).onFinish();
    }

    @Test
    void shouldResetPendingFailureAndIgnored() {
        this.state.setResponseHandler(null);
        Neo4jError error = Neo4jError.from((Throwable)new RuntimeException());
        this.state.markIgnored();
        this.state.markFailed(error);
        Assertions.assertEquals((Object)error, (Object)this.state.getPendingError());
        Assertions.assertTrue((boolean)this.state.hasPendingIgnore());
        this.state.resetPendingFailedAndIgnored();
        Assertions.assertNull((Object)this.state.getPendingError());
        Assertions.assertFalse((boolean)this.state.hasPendingIgnore());
    }

    @Test
    void shouldNotProcessMessageWhenClosed() {
        this.state.setResponseHandler(null);
        this.state.markClosed();
        Assertions.assertFalse((boolean)this.state.canProcessMessage());
    }

    @Test
    void shouldNotProcessMessageWithPendingError() {
        this.state.setResponseHandler(null);
        this.state.markFailed(Neo4jError.from((Throwable)new RuntimeException()));
        Assertions.assertFalse((boolean)this.state.canProcessMessage());
    }

    @Test
    void shouldNotProcessMessageWithPendingIgnore() {
        this.state.setResponseHandler(null);
        this.state.markIgnored();
        Assertions.assertFalse((boolean)this.state.canProcessMessage());
    }

    @Test
    void shouldInterrupt() {
        Assertions.assertFalse((boolean)this.state.isInterrupted());
        Assertions.assertEquals((int)1, (int)this.state.incrementInterruptCounter());
        Assertions.assertTrue((boolean)this.state.isInterrupted());
        Assertions.assertEquals((int)2, (int)this.state.incrementInterruptCounter());
        Assertions.assertTrue((boolean)this.state.isInterrupted());
        Assertions.assertEquals((int)3, (int)this.state.incrementInterruptCounter());
        Assertions.assertTrue((boolean)this.state.isInterrupted());
        Assertions.assertEquals((int)2, (int)this.state.decrementInterruptCounter());
        Assertions.assertTrue((boolean)this.state.isInterrupted());
        Assertions.assertEquals((int)1, (int)this.state.decrementInterruptCounter());
        Assertions.assertTrue((boolean)this.state.isInterrupted());
        Assertions.assertEquals((int)0, (int)this.state.decrementInterruptCounter());
        Assertions.assertFalse((boolean)this.state.isInterrupted());
    }
}

