/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.runtime.CachedThreadPoolExecutorFactory;
import org.neo4j.bolt.runtime.ExecutorFactory;
import org.neo4j.function.Predicates;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

@RunWith(value=Parameterized.class)
public class CachedThreadPoolExecutorFactoryTest {
    private static final int TEST_BOUNDED_QUEUE_SIZE = 5;
    private final ExecutorFactory factory = new CachedThreadPoolExecutorFactory((Log)NullLog.getInstance());
    private ExecutorService executorService;
    @Parameterized.Parameter(value=0)
    public int queueSize;
    @Parameterized.Parameter(value=1)
    public String name;

    @Parameterized.Parameters(name="{1}")
    public static List<Object[]> parameters() {
        return Arrays.asList({-1, "Unbounded Queue"}, {0, "Synchronous Queue"}, {5, "Bounded Queue"});
    }

    @After
    public void cleanup() {
        if (this.executorService != null && !this.executorService.isTerminated()) {
            this.executorService.shutdown();
        }
    }

    @Test
    public void createShouldAssignCorrectQueue() {
        this.executorService = this.factory.create(0, 1, Duration.ZERO, this.queueSize, false, CachedThreadPoolExecutorFactoryTest.newThreadFactory());
        if (this.executorService instanceof ThreadPoolExecutor) {
            BlockingQueue<Runnable> queue = ((ThreadPoolExecutor)this.executorService).getQueue();
            switch (this.queueSize) {
                case -1: {
                    Assert.assertThat(queue, (Matcher)CoreMatchers.instanceOf(LinkedBlockingQueue.class));
                    Assert.assertEquals((long)Integer.MAX_VALUE, (long)queue.remainingCapacity());
                    break;
                }
                case 0: {
                    Assert.assertThat(queue, (Matcher)CoreMatchers.instanceOf(SynchronousQueue.class));
                    break;
                }
                case 5: {
                    Assert.assertThat(queue, (Matcher)CoreMatchers.instanceOf(ArrayBlockingQueue.class));
                    Assert.assertEquals((long)this.queueSize, (long)queue.remainingCapacity());
                    break;
                }
                default: {
                    Assert.fail((String)String.format("Unexpected queue size %d", this.queueSize));
                }
            }
        }
    }

    @Test
    public void createShouldCreateExecutor() {
        this.executorService = this.factory.create(0, 1, Duration.ZERO, this.queueSize, false, CachedThreadPoolExecutorFactoryTest.newThreadFactory());
        Assert.assertNotNull((Object)this.executorService);
        Assert.assertFalse((boolean)this.executorService.isShutdown());
        Assert.assertFalse((boolean)this.executorService.isTerminated());
    }

    @Test
    public void createShouldNotCreateExecutorWhenCorePoolSizeIsNegative() {
        try {
            this.factory.create(-1, 10, Duration.ZERO, 0, false, CachedThreadPoolExecutorFactoryTest.newThreadFactory());
            Assert.fail((String)"should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createShouldNotCreateExecutorWhenMaxPoolSizeIsNegative() {
        try {
            this.factory.create(0, -1, Duration.ZERO, 0, false, CachedThreadPoolExecutorFactoryTest.newThreadFactory());
            Assert.fail((String)"should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createShouldNotCreateExecutorWhenMaxPoolSizeIsZero() {
        try {
            this.factory.create(0, 0, Duration.ZERO, 0, false, CachedThreadPoolExecutorFactoryTest.newThreadFactory());
            Assert.fail((String)"should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createShouldStartCoreThreadsIfAsked() {
        AtomicInteger threadCounter = new AtomicInteger();
        this.factory.create(5, 10, Duration.ZERO, 0, true, CachedThreadPoolExecutorFactoryTest.newThreadFactoryWithCounter(threadCounter));
        Assert.assertEquals((long)5L, (long)threadCounter.get());
    }

    @Test
    public void createShouldNotStartCoreThreadsIfNotAsked() {
        AtomicInteger threadCounter = new AtomicInteger();
        this.factory.create(5, 10, Duration.ZERO, 0, false, CachedThreadPoolExecutorFactoryTest.newThreadFactoryWithCounter(threadCounter));
        Assert.assertEquals((long)0L, (long)threadCounter.get());
    }

    @Test
    public void createShouldNotCreateExecutorWhenMaxPoolSizeIsLessThanCorePoolSize() {
        try {
            this.factory.create(10, 5, Duration.ZERO, 0, false, CachedThreadPoolExecutorFactoryTest.newThreadFactory());
            Assert.fail((String)"should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createdExecutorShouldExecuteSubmittedTasks() throws Exception {
        AtomicBoolean exitCondition = new AtomicBoolean(false);
        AtomicInteger threadCounter = new AtomicInteger(0);
        this.executorService = this.factory.create(0, 1, Duration.ZERO, 0, false, CachedThreadPoolExecutorFactoryTest.newThreadFactoryWithCounter(threadCounter));
        Assert.assertNotNull((Object)this.executorService);
        Assert.assertEquals((long)0L, (long)threadCounter.get());
        Future<?> task1 = this.executorService.submit(CachedThreadPoolExecutorFactoryTest.newInfiniteWaitingRunnable(exitCondition));
        Assert.assertEquals((long)1L, (long)threadCounter.get());
        exitCondition.set(true);
        Assert.assertNull(task1.get(1L, TimeUnit.MINUTES));
        Assert.assertTrue((boolean)task1.isDone());
        Assert.assertFalse((boolean)task1.isCancelled());
    }

    @Test
    public void createdExecutorShouldFavorPoolSizes() {
        AtomicBoolean exitCondition = new AtomicBoolean(false);
        AtomicInteger threadCounter = new AtomicInteger(0);
        this.executorService = this.factory.create(0, 5, Duration.ZERO, 0, false, CachedThreadPoolExecutorFactoryTest.newThreadFactoryWithCounter(threadCounter));
        Assert.assertNotNull((Object)this.executorService);
        Assert.assertEquals((long)0L, (long)threadCounter.get());
        try {
            for (int i = 0; i < 6; ++i) {
                this.executorService.submit(CachedThreadPoolExecutorFactoryTest.newInfiniteWaitingRunnable(exitCondition));
            }
            Assert.fail((String)"should throw exception");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        Assert.assertEquals((long)5L, (long)threadCounter.get());
    }

    private static Runnable newInfiniteWaitingRunnable(AtomicBoolean exitCondition) {
        return () -> Predicates.awaitForever(() -> Thread.currentThread().isInterrupted() || exitCondition.get(), (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private static ThreadFactory newThreadFactory() {
        return Executors.defaultThreadFactory();
    }

    private static ThreadFactory newThreadFactoryWithCounter(AtomicInteger counter) {
        return job -> {
            counter.incrementAndGet();
            return Executors.defaultThreadFactory().newThread(job);
        };
    }
}

