/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.messaging;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.bolt.runtime.SynchronousBoltConnection;
import org.neo4j.kernel.api.exceptions.Status;

class BoltRequestMessageReaderTest {
    BoltRequestMessageReaderTest() {
    }

    @Test
    public void shouldPropagateFatalError() throws Exception {
        Neo4jPack.Unpacker unpacker = (Neo4jPack.Unpacker)Mockito.mock(Neo4jPack.Unpacker.class);
        RuntimeException error = new RuntimeException();
        Mockito.when((Object)unpacker.unpackStructHeader()).thenThrow(new Throwable[]{error});
        TestBoltRequestMessageReader reader = new TestBoltRequestMessageReader(BoltRequestMessageReaderTest.connectionMock(), BoltRequestMessageReaderTest.responseHandlerMock(), Collections.emptyList());
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> reader.read(unpacker));
        Assertions.assertEquals((Object)error, (Object)e);
    }

    @Test
    public void shouldHandleErrorThatCausesFailureMessage() throws Exception {
        Neo4jPack.Unpacker unpacker = (Neo4jPack.Unpacker)Mockito.mock(Neo4jPack.Unpacker.class);
        BoltIOException error = new BoltIOException((Status)Status.General.UnknownError, "Hello");
        Mockito.when((Object)unpacker.unpackStructHeader()).thenThrow(new Throwable[]{error});
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        SynchronousBoltConnection connection = new SynchronousBoltConnection(stateMachine);
        BoltResponseHandler externalErrorResponseHandler = BoltRequestMessageReaderTest.responseHandlerMock();
        TestBoltRequestMessageReader reader = new TestBoltRequestMessageReader(connection, externalErrorResponseHandler, Collections.emptyList());
        reader.read(unpacker);
        ((BoltStateMachine)Mockito.verify((Object)stateMachine)).handleExternalFailure(Neo4jError.from((Throwable)error), externalErrorResponseHandler);
    }

    @Test
    public void shouldThrowForUnknownMessage() throws Exception {
        Neo4jPack.Unpacker unpacker = (Neo4jPack.Unpacker)Mockito.mock(Neo4jPack.Unpacker.class);
        Mockito.when((Object)Character.valueOf(unpacker.unpackStructSignature())).thenReturn((Object)Character.valueOf('a'));
        TestRequestMessageDecoder decoder = new TestRequestMessageDecoder(98, BoltRequestMessageReaderTest.responseHandlerMock(), (RequestMessage)Mockito.mock(RequestMessage.class));
        TestBoltRequestMessageReader reader = new TestBoltRequestMessageReader(BoltRequestMessageReaderTest.connectionMock(), BoltRequestMessageReaderTest.responseHandlerMock(), Collections.singletonList(decoder));
        BoltIOException e = (BoltIOException)Assertions.assertThrows(BoltIOException.class, () -> reader.read(unpacker));
        Assertions.assertEquals((Object)Status.Request.InvalidFormat, (Object)e.status());
        Assertions.assertFalse((boolean)e.causesFailureMessage());
        Assertions.assertEquals((Object)"Message 0x61 is not a valid message signature.", (Object)e.getMessage());
    }

    @Test
    public void shouldDecodeKnownMessage() throws Exception {
        Neo4jPack.Unpacker unpacker = (Neo4jPack.Unpacker)Mockito.mock(Neo4jPack.Unpacker.class);
        Mockito.when((Object)Character.valueOf(unpacker.unpackStructSignature())).thenReturn((Object)Character.valueOf('a'));
        RequestMessage message = (RequestMessage)Mockito.mock(RequestMessage.class);
        BoltResponseHandler responseHandler = BoltRequestMessageReaderTest.responseHandlerMock();
        TestRequestMessageDecoder decoder = new TestRequestMessageDecoder(97, responseHandler, message);
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        SynchronousBoltConnection connection = new SynchronousBoltConnection(stateMachine);
        TestBoltRequestMessageReader reader = new TestBoltRequestMessageReader(connection, BoltRequestMessageReaderTest.responseHandlerMock(), Collections.singletonList(decoder));
        reader.read(unpacker);
        ((BoltStateMachine)Mockito.verify((Object)stateMachine)).process(message, responseHandler);
    }

    private static BoltConnection connectionMock() {
        return (BoltConnection)Mockito.mock(BoltConnection.class);
    }

    private static BoltResponseHandler responseHandlerMock() {
        return (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
    }

    private static class TestRequestMessageDecoder
    implements RequestMessageDecoder {
        final int signature;
        final BoltResponseHandler responseHandler;
        final RequestMessage message;

        TestRequestMessageDecoder(int signature, BoltResponseHandler responseHandler, RequestMessage message) {
            this.signature = signature;
            this.responseHandler = responseHandler;
            this.message = message;
        }

        public int signature() {
            return this.signature;
        }

        public BoltResponseHandler responseHandler() {
            return this.responseHandler;
        }

        public RequestMessage decode(Neo4jPack.Unpacker unpacker) throws IOException {
            return this.message;
        }
    }

    private static class TestBoltRequestMessageReader
    extends BoltRequestMessageReader {
        TestBoltRequestMessageReader(BoltConnection connection, BoltResponseHandler externalErrorResponseHandler, List<RequestMessageDecoder> decoders) {
            super(connection, externalErrorResponseHandler, decoders);
        }
    }
}

