/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.embedded.EmbeddedChannel;
import java.net.SocketAddress;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;

class BoltChannelTest {
    private final Channel channel = (Channel)Mockito.mock(Channel.class);

    BoltChannelTest() {
    }

    @Test
    void shouldCloseUnderlyingChannelWhenItIsOpen() {
        Channel channel = BoltChannelTest.channelMock(true);
        BoltChannel boltChannel = new BoltChannel("bolt-1", "bolt", channel);
        boltChannel.close();
        ((Channel)Mockito.verify((Object)channel)).close();
    }

    @Test
    void shouldNotCloseUnderlyingChannelWhenItIsClosed() {
        Channel channel = BoltChannelTest.channelMock(false);
        BoltChannel boltChannel = new BoltChannel("bolt-1", "bolt", channel);
        boltChannel.close();
        ((Channel)Mockito.verify((Object)channel, (VerificationMode)Mockito.never())).close();
    }

    @Test
    void shouldHaveId() {
        BoltChannel boltChannel = new BoltChannel("bolt-42", "bolt", this.channel);
        Assertions.assertEquals((Object)"bolt-42", (Object)boltChannel.id());
    }

    @Test
    void shouldHaveConnector() {
        BoltChannel boltChannel = new BoltChannel("bolt-1", "my-bolt", this.channel);
        Assertions.assertEquals((Object)"my-bolt", (Object)boltChannel.connector());
    }

    @Test
    void shouldHaveConnectTime() {
        BoltChannel boltChannel = new BoltChannel("bolt-1", "my-bolt", this.channel);
        MatcherAssert.assertThat((Object)boltChannel.connectTime(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    @Test
    void shouldHaveUsernameAndUserAgent() {
        BoltChannel boltChannel = new BoltChannel("bolt-1", "my-bolt", this.channel);
        Assertions.assertNull((Object)boltChannel.username());
        boltChannel.updateUser("hello", "my-bolt-driver/1.2.3");
        Assertions.assertEquals((Object)"hello", (Object)boltChannel.username());
        Assertions.assertEquals((Object)"my-bolt-driver/1.2.3", (Object)boltChannel.userAgent());
    }

    @Test
    void shouldExposeClientConnectionInfo() {
        EmbeddedChannel channel = new EmbeddedChannel();
        BoltChannel boltChannel = new BoltChannel("bolt-42", "my-bolt", (Channel)channel);
        ClientConnectionInfo info1 = boltChannel.info();
        Assertions.assertEquals((Object)"bolt-42", (Object)info1.connectionId());
        Assertions.assertEquals((Object)"bolt", (Object)info1.protocol());
        Assertions.assertEquals((Object)org.neo4j.helpers.SocketAddress.format((SocketAddress)channel.remoteAddress()), (Object)info1.clientAddress());
        boltChannel.updateUser("Tom", "my-driver");
        ClientConnectionInfo info2 = boltChannel.info();
        Assertions.assertEquals((Object)"bolt-42", (Object)info2.connectionId());
        Assertions.assertEquals((Object)"bolt", (Object)info2.protocol());
        Assertions.assertEquals((Object)org.neo4j.helpers.SocketAddress.format((SocketAddress)channel.remoteAddress()), (Object)info2.clientAddress());
        MatcherAssert.assertThat((Object)info2.asConnectionDetails(), (Matcher)Matchers.containsString((String)"Tom"));
        MatcherAssert.assertThat((Object)info2.asConnectionDetails(), (Matcher)Matchers.containsString((String)"my-driver"));
    }

    private static Channel channelMock(boolean open) {
        Channel channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)channel.isOpen()).thenReturn((Object)open);
        ChannelFuture channelFuture = (ChannelFuture)Mockito.mock(ChannelFuture.class);
        Mockito.when((Object)channel.close()).thenReturn((Object)channelFuture);
        return channel;
    }
}

