/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.bookmarking;

import java.util.List;
import java.util.Map;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;

public class Bookmark {
    private static final String BOOKMARK_KEY = "bookmark";
    private static final String BOOKMARKS_KEY = "bookmarks";
    private static final String BOOKMARK_TX_PREFIX = "neo4j:bookmark:v1:tx";
    private final long txId;

    public Bookmark(long txId) {
        this.txId = txId;
    }

    public String toString() {
        return String.format("neo4j:bookmark:v1:tx%d", this.txId);
    }

    public static Bookmark fromParamsOrNull(Map<String, Object> params) throws BookmarkFormatException {
        Bookmark bookmark = Bookmark.parseMultipleBookmarks(params);
        if (bookmark == null) {
            return Bookmark.parseSingleBookmark(params);
        }
        return bookmark;
    }

    public long txId() {
        return this.txId;
    }

    private static Bookmark parseMultipleBookmarks(Map<String, Object> params) throws BookmarkFormatException {
        Object bookmarksObject = params.get(BOOKMARKS_KEY);
        if (bookmarksObject == null) {
            return null;
        }
        if (bookmarksObject instanceof List) {
            List bookmarks = (List)bookmarksObject;
            long maxTxId = -1L;
            for (Object bookmark : bookmarks) {
                long txId;
                if (bookmark == null || (txId = Bookmark.txIdFrom(bookmark.toString())) <= maxTxId) continue;
                maxTxId = txId;
            }
            return maxTxId == -1L ? null : new Bookmark(maxTxId);
        }
        throw new BookmarkFormatException(bookmarksObject);
    }

    private static Bookmark parseSingleBookmark(Map<String, Object> params) throws BookmarkFormatException {
        Object bookmarkObject = params.get(BOOKMARK_KEY);
        if (bookmarkObject == null) {
            return null;
        }
        String bookmarkString = bookmarkObject.toString();
        return new Bookmark(Bookmark.txIdFrom(bookmarkString));
    }

    private static long txIdFrom(String bookmarkString) throws BookmarkFormatException {
        if (!bookmarkString.startsWith(BOOKMARK_TX_PREFIX)) {
            throw new BookmarkFormatException(bookmarkString);
        }
        try {
            return Long.parseLong(bookmarkString.substring(BOOKMARK_TX_PREFIX.length()));
        }
        catch (NumberFormatException e) {
            throw new BookmarkFormatException(bookmarkString, e);
        }
    }

    static class BookmarkFormatException
    extends KernelException {
        BookmarkFormatException(String bookmarkString, NumberFormatException e) {
            super((Status)Status.Transaction.InvalidBookmark, (Throwable)e, "Supplied bookmark [%s] does not conform to pattern %s; unable to parse transaction id", new Object[]{bookmarkString, Bookmark.BOOKMARK_TX_PREFIX});
        }

        BookmarkFormatException(Object bookmarkObject) {
            super((Status)Status.Transaction.InvalidBookmark, "Supplied bookmark [%s] does not conform to pattern %s", new Object[]{bookmarkObject, Bookmark.BOOKMARK_TX_PREFIX});
        }
    }
}

