/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.Map;
import java.util.regex.Pattern;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v1.runtime.BoltQuerySource;
import org.neo4j.bolt.v1.runtime.StatementMetadata;
import org.neo4j.bolt.v1.runtime.StatementProcessor;
import org.neo4j.bolt.v1.runtime.bookmarking.Bookmark;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.bolt.v1.runtime.spi.BookmarkResult;
import org.neo4j.cypher.InvalidSemanticsException;
import org.neo4j.function.ThrowingAction;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;

public class TransactionStateMachine
implements StatementProcessor {
    private static final Pattern BEGIN = Pattern.compile("(?i)^\\s*BEGIN\\s*;?\\s*$");
    private static final Pattern COMMIT = Pattern.compile("(?i)^\\s*COMMIT\\s*;?\\s*$");
    private static final Pattern ROLLBACK = Pattern.compile("(?i)^\\s*ROLLBACK\\s*;?\\s*$");
    final SPI spi;
    final MutableTransactionState ctx;
    State state = State.AUTO_COMMIT;

    TransactionStateMachine(SPI spi, AuthenticationResult authenticationResult, Clock clock) {
        this.spi = spi;
        this.ctx = new MutableTransactionState(authenticationResult, clock);
    }

    public State state() {
        return this.state;
    }

    private void before() {
        if (this.ctx.currentTransaction != null) {
            this.spi.bindTransactionToCurrentThread(this.ctx.currentTransaction);
        }
    }

    @Override
    public StatementMetadata run(String statement, Map<String, Object> params) throws KernelException {
        this.before();
        try {
            this.state = this.state.run(this.ctx, this.spi, statement, params);
            StatementMetadata statementMetadata = this.ctx.currentStatementMetadata;
            return statementMetadata;
        }
        catch (TransactionFailureException ex) {
            this.state = State.AUTO_COMMIT;
            throw ex;
        }
        finally {
            this.after();
        }
    }

    @Override
    public void streamResult(ThrowingConsumer<BoltResult, Exception> resultConsumer) throws Exception {
        this.before();
        try {
            this.state.streamResult(this.ctx, resultConsumer);
        }
        finally {
            this.after();
        }
    }

    @Override
    public void reset() throws TransactionFailureException {
        this.state.terminateQueryAndRollbackTransaction(this.ctx);
        this.state = State.AUTO_COMMIT;
    }

    private void after() {
        if (this.ctx.currentTransaction != null) {
            this.spi.unbindTransactionFromCurrentThread();
        }
    }

    @Override
    public void markCurrentTransactionForTermination() {
        KernelTransaction tx = this.ctx.currentTransaction;
        if (tx != null) {
            tx.markForTermination((Status)Status.Transaction.Terminated);
        }
    }

    @Override
    public boolean hasTransaction() {
        return this.state == State.EXPLICIT_TRANSACTION;
    }

    @Override
    public void setQuerySource(BoltQuerySource querySource) {
        this.ctx.querySource = querySource;
    }

    private static BoltResultHandle executeQuery(MutableTransactionState ctx, SPI spi, String statement, Map<String, Object> params, ThrowingAction<KernelException> onFail) throws QueryExecutionKernelException {
        return spi.executeQuery(ctx.querySource, ctx.securityContext, statement, params, onFail);
    }

    static interface SPI {
        public void awaitUpToDate(long var1) throws TransactionFailureException;

        public long newestEncounteredTxId();

        public KernelTransaction beginTransaction(SecurityContext var1);

        public void bindTransactionToCurrentThread(KernelTransaction var1);

        public void unbindTransactionFromCurrentThread();

        public boolean isPeriodicCommit(String var1);

        public BoltResultHandle executeQuery(BoltQuerySource var1, SecurityContext var2, String var3, Map<String, Object> var4, ThrowingAction<KernelException> var5) throws QueryExecutionKernelException;
    }

    static class MutableTransactionState {
        final SecurityContext securityContext;
        KernelTransaction currentTransaction;
        String lastStatement = "";
        BoltResult currentResult;
        final Clock clock;
        private final StatementMetadata currentStatementMetadata = new StatementMetadata(){

            @Override
            public String[] fieldNames() {
                return currentResult.fieldNames();
            }
        };
        BoltQuerySource querySource;
        BoltResultHandle currentResultHandle;

        private MutableTransactionState(AuthenticationResult authenticationResult, Clock clock) {
            this.clock = clock;
            this.securityContext = authenticationResult.getSecurityContext();
        }
    }

    static interface BoltResultHandle {
        public BoltResult start() throws KernelException;

        public void terminate();
    }

    static enum State {
        AUTO_COMMIT{

            @Override
            State run(MutableTransactionState ctx, SPI spi, String statement, Map<String, Object> params) throws KernelException {
                BoltResultHandle resultHandle;
                if (BEGIN.matcher(statement).matches()) {
                    ctx.currentTransaction = spi.beginTransaction(ctx.securityContext);
                    Bookmark bookmark = Bookmark.fromParamsOrNull(params);
                    if (bookmark != null) {
                        spi.awaitUpToDate(bookmark.txId());
                        ctx.currentResult = new BookmarkResult(bookmark);
                    } else {
                        ctx.currentResult = BoltResult.EMPTY;
                    }
                    return EXPLICIT_TRANSACTION;
                }
                if (COMMIT.matcher(statement).matches()) {
                    throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("No current transaction to commit."));
                }
                if (ROLLBACK.matcher(statement).matches()) {
                    throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("No current transaction to rollback."));
                }
                if (statement.isEmpty()) {
                    statement = ctx.lastStatement;
                } else {
                    ctx.lastStatement = statement;
                }
                if (spi.isPeriodicCommit(statement)) {
                    BoltResultHandle resultHandle2;
                    ctx.currentResultHandle = resultHandle2 = TransactionStateMachine.executeQuery(ctx, spi, statement, params, (ThrowingAction<KernelException>)ThrowingAction.noop());
                    ctx.currentResult = resultHandle2.start();
                    ctx.currentTransaction = null;
                    return AUTO_COMMIT;
                }
                ctx.currentTransaction = spi.beginTransaction(ctx.securityContext);
                ctx.currentResultHandle = resultHandle = this.execute(ctx, spi, statement, params);
                ctx.currentResult = resultHandle.start();
                return AUTO_COMMIT;
            }

            private BoltResultHandle execute(MutableTransactionState ctx, SPI spi, String statement, Map<String, Object> params) throws TransactionFailureException, QueryExecutionKernelException {
                return TransactionStateMachine.executeQuery(ctx, spi, statement, params, (ThrowingAction<KernelException>)() -> this.closeTransaction(ctx, false));
            }

            @Override
            void streamResult(MutableTransactionState ctx, ThrowingConsumer<BoltResult, Exception> resultConsumer) throws Exception {
                assert (ctx.currentResult != null);
                resultConsumer.accept((Object)ctx.currentResult);
                ctx.currentResult.close();
                this.closeTransaction(ctx, true);
            }
        }
        ,
        EXPLICIT_TRANSACTION{

            @Override
            State run(MutableTransactionState ctx, SPI spi, String statement, Map<String, Object> params) throws KernelException {
                if (BEGIN.matcher(statement).matches()) {
                    throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("Nested transactions are not supported."));
                }
                if (COMMIT.matcher(statement).matches()) {
                    this.closeTransaction(ctx, true);
                    long txId = spi.newestEncounteredTxId();
                    Bookmark bookmark = new Bookmark(txId);
                    ctx.currentResult = new BookmarkResult(bookmark);
                    return AUTO_COMMIT;
                }
                if (ROLLBACK.matcher(statement).matches()) {
                    this.closeTransaction(ctx, false);
                    ctx.currentResult = BoltResult.EMPTY;
                    return AUTO_COMMIT;
                }
                if (statement.isEmpty()) {
                    statement = ctx.lastStatement;
                } else {
                    ctx.lastStatement = statement;
                }
                if (spi.isPeriodicCommit(statement)) {
                    throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("Executing queries that use periodic commit in an open transaction is not possible."));
                }
                ctx.currentResultHandle = this.execute(ctx, spi, statement, params);
                ctx.currentResult = ctx.currentResultHandle.start();
                return EXPLICIT_TRANSACTION;
            }

            private BoltResultHandle execute(MutableTransactionState ctx, SPI spi, String statement, Map<String, Object> params) throws QueryExecutionKernelException {
                return TransactionStateMachine.executeQuery(ctx, spi, statement, params, (ThrowingAction<KernelException>)() -> {
                    if (ctx.currentTransaction != null) {
                        ctx.currentTransaction.failure();
                    }
                });
            }

            @Override
            void streamResult(MutableTransactionState ctx, ThrowingConsumer<BoltResult, Exception> resultConsumer) throws Exception {
                assert (ctx.currentResult != null);
                resultConsumer.accept((Object)ctx.currentResult);
                ctx.currentResult.close();
            }
        };


        abstract State run(MutableTransactionState var1, SPI var2, String var3, Map<String, Object> var4) throws KernelException;

        abstract void streamResult(MutableTransactionState var1, ThrowingConsumer<BoltResult, Exception> var2) throws Exception;

        void terminateQueryAndRollbackTransaction(MutableTransactionState ctx) throws TransactionFailureException {
            if (ctx.currentResultHandle != null) {
                ctx.currentResultHandle.terminate();
                ctx.currentResultHandle = null;
            }
            if (ctx.currentResult != null) {
                ctx.currentResult.close();
                ctx.currentResult = null;
            }
            this.closeTransaction(ctx, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeTransaction(MutableTransactionState ctx, boolean success) throws TransactionFailureException {
            KernelTransaction tx = ctx.currentTransaction;
            ctx.currentTransaction = null;
            if (tx != null) {
                try {
                    if (success) {
                        tx.success();
                    } else {
                        tx.failure();
                    }
                    if (tx.isOpen()) {
                        tx.close();
                    }
                }
                finally {
                    ctx.currentTransaction = null;
                }
            }
        }
    }
}

