/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.ExecutionPlanDescription;

class ExecutionPlanConverter {
    private ExecutionPlanConverter() {
    }

    public static Map<String, Object> convert(ExecutionPlanDescription plan) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        out.put("operatorType", plan.getName());
        out.put("args", plan.getArguments());
        out.put("identifiers", plan.getIdentifiers());
        out.put("children", ExecutionPlanConverter.children(plan));
        if (plan.hasProfilerStatistics()) {
            ExecutionPlanDescription.ProfilerStatistics profile = plan.getProfilerStatistics();
            out.put("dbHits", profile.getDbHits());
            out.put("pageCacheHits", profile.getPageCacheHits());
            out.put("pageCacheMisses", profile.getPageCacheMisses());
            out.put("pageCacheHitRatio", profile.getPageCacheHitRatio());
            out.put("rows", profile.getRows());
        }
        return out;
    }

    private static List<Map<String, Object>> children(ExecutionPlanDescription plan) {
        LinkedList<Map<String, Object>> children = new LinkedList<Map<String, Object>>();
        for (ExecutionPlanDescription child : plan.getChildren()) {
            children.add(ExecutionPlanConverter.convert(child));
        }
        return children;
    }
}

