/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.time.Duration;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.v1.runtime.BoltConnectionDescriptor;
import org.neo4j.bolt.v1.runtime.BoltFactory;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.BoltStateMachineSPI;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;
import org.neo4j.bolt.v1.runtime.TransactionStateMachineSPI;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.udc.UsageData;

public class BoltFactoryImpl
extends LifecycleAdapter
implements BoltFactory {
    private final GraphDatabaseAPI gds;
    private final UsageData usageData;
    private final LogService logging;
    private final Authentication authentication;
    private final BoltConnectionTracker connectionTracker;
    private final ThreadToStatementContextBridge txBridge;
    private final Config config;
    private QueryExecutionEngine queryExecutionEngine;
    private GraphDatabaseQueryService queryService;
    private AvailabilityGuard availabilityGuard;
    private DependencyResolver dependencyResolver;

    public BoltFactoryImpl(GraphDatabaseAPI gds, UsageData usageData, LogService logging, ThreadToStatementContextBridge txBridge, Authentication authentication, BoltConnectionTracker connectionTracker, Config config) {
        this.gds = gds;
        this.usageData = usageData;
        this.logging = logging;
        this.txBridge = txBridge;
        this.authentication = authentication;
        this.connectionTracker = connectionTracker;
        this.config = config;
    }

    public void start() throws Throwable {
        this.dependencyResolver = this.gds.getDependencyResolver();
        this.queryExecutionEngine = (QueryExecutionEngine)this.dependencyResolver.resolveDependency(QueryExecutionEngine.class);
        this.queryService = (GraphDatabaseQueryService)this.dependencyResolver.resolveDependency(GraphDatabaseQueryService.class);
        this.availabilityGuard = (AvailabilityGuard)this.dependencyResolver.resolveDependency(AvailabilityGuard.class);
    }

    public void stop() throws Throwable {
        this.queryExecutionEngine = null;
        this.queryService = null;
        this.availabilityGuard = null;
    }

    @Override
    public BoltStateMachine newMachine(BoltConnectionDescriptor connectionDescriptor, Runnable onClose, Clock clock) {
        TransactionStateMachine.SPI transactionSPI = this.createTxSpi(clock);
        BoltStateMachineSPI boltSPI = new BoltStateMachineSPI(connectionDescriptor, this.usageData, this.logging, this.authentication, this.connectionTracker, transactionSPI);
        return new BoltStateMachine(boltSPI, onClose, clock);
    }

    private TransactionStateMachine.SPI createTxSpi(Clock clock) {
        long bookmarkReadyTimeout = ((Duration)this.config.get(GraphDatabaseSettings.bookmark_ready_timeout)).toMillis();
        Duration txAwaitDuration = Duration.ofMillis(bookmarkReadyTimeout);
        return new TransactionStateMachineSPI(this.gds, this.txBridge, this.queryExecutionEngine, this.availabilityGuard, this.queryService, txAwaitDuration, clock);
    }
}

