/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.PortBindException;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class NettyServer
extends LifecycleAdapter {
    private static final int NUM_SELECTOR_THREADS = Math.max(1, Integer.getInteger("org.neo4j.selectorThreads", Runtime.getRuntime().availableProcessors() * 2));
    private final Map<BoltConnector, ProtocolInitializer> bootstrappersMap;
    private final ThreadFactory tf;
    private final ConnectorPortRegister connectionRegister;
    private EventLoopGroup bossGroup;
    private EventLoopGroup selectorGroup;

    public NettyServer(ThreadFactory tf, Map<BoltConnector, ProtocolInitializer> initializersMap, ConnectorPortRegister connectorRegister) {
        this.bootstrappersMap = initializersMap;
        this.tf = tf;
        this.connectionRegister = connectorRegister;
    }

    public void start() throws Throwable {
        this.bossGroup = new NioEventLoopGroup(1, this.tf);
        this.selectorGroup = new NioEventLoopGroup(NUM_SELECTOR_THREADS, this.tf);
        for (Map.Entry<BoltConnector, ProtocolInitializer> bootstrapEntry : this.bootstrappersMap.entrySet()) {
            try {
                ProtocolInitializer protocolInitializer = bootstrapEntry.getValue();
                BoltConnector boltConnector = bootstrapEntry.getKey();
                ChannelFuture channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).group(this.bossGroup, this.selectorGroup).channel(NioServerSocketChannel.class)).childHandler(protocolInitializer.channelInitializer()).bind((SocketAddress)protocolInitializer.address().socketAddress()).sync();
                InetSocketAddress localAddress = (InetSocketAddress)channelFuture.channel().localAddress();
                this.connectionRegister.register(boltConnector.key(), localAddress);
            }
            catch (Throwable e) {
                if (e instanceof BindException) {
                    throw new PortBindException(bootstrapEntry.getValue().address(), (BindException)e);
                }
                throw e;
            }
        }
    }

    public void stop() throws Throwable {
        this.bossGroup.shutdownGracefully();
        this.selectorGroup.shutdownGracefully();
    }

    public static interface ProtocolInitializer {
        public ChannelInitializer<SocketChannel> channelInitializer();

        public ListenSocketAddress address();
    }
}

