/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.socket.client;

import java.io.IOException;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.bolt.v1.transport.socket.client.WebSocketConnection;
import org.neo4j.test.rule.SuppressOutput;

public class WebSocketConnectionTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Test
    public void shouldNotThrowAnyExceptionWhenDataReceivedBeforeClose() throws Throwable {
        WebSocketClient client = (WebSocketClient)Mockito.mock(WebSocketClient.class);
        WebSocketConnection conn = new WebSocketConnection(client);
        Mockito.when((Object)client.isStopped()).thenReturn((Object)true);
        byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        conn.onWebSocketBinary(data, 0, 10);
        conn.recv(10);
    }

    @Test
    public void shouldThrowIOExceptionWhenNotEnoughDataReceivedBeforeClose() throws Throwable {
        WebSocketClient client = (WebSocketClient)Mockito.mock(WebSocketClient.class);
        WebSocketConnection conn = new WebSocketConnection(client);
        Mockito.when((Object)client.isStopped()).thenReturn((Object)true, (Object[])new Boolean[]{true});
        byte[] data = new byte[]{0, 1, 2, 3};
        conn.onWebSocketBinary(data, 0, 4);
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage("Connection closed while waiting for data from the server.");
        conn.recv(10);
    }
}

