/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.socket.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;
import org.neo4j.helpers.HostnamePort;

public class SocketConnectionTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void shouldOnlyReadOnceIfAllBytesAreRead() throws Exception {
        Socket socket = (Socket)Mockito.mock(Socket.class);
        InputStream stream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)socket.getInputStream()).thenReturn((Object)stream);
        Mockito.when((Object)stream.read((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)4);
        SocketConnection connection = new SocketConnection(socket);
        connection.connect(new HostnamePort("my.domain", 1234));
        connection.recv(4);
        ((InputStream)Mockito.verify((Object)stream, (VerificationMode)Mockito.times((int)1))).read((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void shouldOnlyReadUntilAllBytesAreRead() throws Exception {
        Socket socket = (Socket)Mockito.mock(Socket.class);
        InputStream stream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)socket.getInputStream()).thenReturn((Object)stream);
        Mockito.when((Object)stream.read((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)4).thenReturn((Object)4).thenReturn((Object)2).thenReturn((Object)-1);
        SocketConnection connection = new SocketConnection(socket);
        connection.connect(new HostnamePort("my.domain", 1234));
        connection.recv(10);
        ((InputStream)Mockito.verify((Object)stream, (VerificationMode)Mockito.times((int)3))).read((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void shouldThrowIfNotEnoughBytesAreRead() throws Exception {
        Socket socket = (Socket)Mockito.mock(Socket.class);
        InputStream stream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)socket.getInputStream()).thenReturn((Object)stream);
        Mockito.when((Object)stream.read((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)4).thenReturn((Object)-1);
        SocketConnection connection = new SocketConnection(socket);
        connection.connect(new HostnamePort("my.domain", 1234));
        this.expectedException.expect(IOException.class);
        connection.recv(10);
    }
}

