/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.socket.client;

import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.neo4j.bolt.v1.transport.socket.client.NaiveTrustManager;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;

public class SecureSocketConnection
extends SocketConnection {
    private final Set<X509Certificate> serverCertificatesSeen = new HashSet<X509Certificate>();

    public SecureSocketConnection() {
        this.setSocket(this.createSecureSocket());
    }

    private Socket createSecureSocket() {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            TrustManager[] trustManagerArray = new TrustManager[1];
            trustManagerArray[0] = new NaiveTrustManager(this.serverCertificatesSeen::add);
            context.init(new KeyManager[0], trustManagerArray, new SecureRandom());
            return context.getSocketFactory().createSocket();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set<X509Certificate> getServerCertificatesSeen() {
        return this.serverCertificatesSeen;
    }
}

