/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.socket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.function.BiFunction;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.transport.BoltProtocol;
import org.neo4j.bolt.transport.ProtocolChooser;
import org.neo4j.bolt.transport.SocketTransportHandler;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.SynchronousBoltWorker;
import org.neo4j.bolt.v1.transport.BoltProtocolV1;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class SocketTransportHandlerTest {
    @Test
    public void shouldCloseProtocolOnChannelInactive() throws Throwable {
        BoltStateMachine machine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        ChannelHandlerContext ctx = SocketTransportHandlerTest.channelHandlerContextMock();
        SocketTransportHandler handler = SocketTransportHandlerTest.newSocketTransportHandler(this.protocolChooser(machine));
        handler.channelRead(ctx, (Object)this.handshake());
        handler.channelInactive(ctx);
        ((BoltStateMachine)Mockito.verify((Object)machine)).close();
    }

    @Test
    public void shouldCloseContextWhenProtocolNotInitializedOnChannelInactive() throws Throwable {
        ChannelHandlerContext context = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        SocketTransportHandler handler = SocketTransportHandlerTest.newSocketTransportHandler((ProtocolChooser)Mockito.mock(ProtocolChooser.class));
        handler.channelInactive(context);
        ((ChannelHandlerContext)Mockito.verify((Object)context)).close();
    }

    @Test
    public void shouldCloseProtocolOnHandlerRemoved() throws Throwable {
        BoltStateMachine machine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        ChannelHandlerContext ctx = SocketTransportHandlerTest.channelHandlerContextMock();
        SocketTransportHandler handler = SocketTransportHandlerTest.newSocketTransportHandler(this.protocolChooser(machine));
        handler.channelRead(ctx, (Object)this.handshake());
        handler.handlerRemoved(ctx);
        ((BoltStateMachine)Mockito.verify((Object)machine)).close();
    }

    @Test
    public void shouldCloseContextWhenProtocolNotInitializedOnHandlerRemoved() throws Throwable {
        ChannelHandlerContext context = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        SocketTransportHandler handler = SocketTransportHandlerTest.newSocketTransportHandler((ProtocolChooser)Mockito.mock(ProtocolChooser.class));
        handler.handlerRemoved(context);
        ((ChannelHandlerContext)Mockito.verify((Object)context)).close();
    }

    @Test
    public void logsAndClosesProtocolOnUnexpectedExceptions() throws Throwable {
        BoltStateMachine machine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        ChannelHandlerContext ctx = SocketTransportHandlerTest.channelHandlerContextMock();
        AssertableLogProvider logging = new AssertableLogProvider();
        SocketTransportHandler handler = new SocketTransportHandler(this.protocolChooser(machine), (LogProvider)logging);
        handler.channelRead(ctx, (Object)this.handshake());
        Throwable cause = new Throwable("Oh no!");
        handler.exceptionCaught(ctx, cause);
        ((BoltStateMachine)Mockito.verify((Object)machine)).close();
        logging.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(SocketTransportHandler.class).error(Matchers.equalTo((Object)"Fatal error occurred when handling a client connection: Oh no!"), Matchers.is((Object)cause))});
    }

    @Test
    public void logsAndClosesContextWhenProtocolNotInitializedOnUnexpectedExceptions() throws Throwable {
        ChannelHandlerContext context = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        AssertableLogProvider logging = new AssertableLogProvider();
        SocketTransportHandler handler = new SocketTransportHandler((ProtocolChooser)Mockito.mock(ProtocolChooser.class), (LogProvider)logging);
        Throwable cause = new Throwable("Oh no!");
        handler.exceptionCaught(context, cause);
        ((ChannelHandlerContext)Mockito.verify((Object)context)).close();
        logging.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(SocketTransportHandler.class).error(Matchers.equalTo((Object)"Fatal error occurred when handling a client connection: Oh no!"), Matchers.is((Object)cause))});
    }

    @Test
    public void shouldInitializeProtocolOnFirstMessage() throws Exception {
        BoltStateMachine machine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        ProtocolChooser chooser = this.protocolChooser(machine);
        ChannelHandlerContext context = SocketTransportHandlerTest.channelHandlerContextMock();
        SocketTransportHandler handler = new SocketTransportHandler(chooser, (LogProvider)NullLogProvider.getInstance());
        handler.channelRead(context, (Object)this.handshake());
        BoltProtocol protocol1 = chooser.chosenProtocol();
        handler.channelRead(context, (Object)this.handshake());
        BoltProtocol protocol2 = chooser.chosenProtocol();
        Assert.assertSame((Object)protocol1, (Object)protocol2);
    }

    private static SocketTransportHandler newSocketTransportHandler(ProtocolChooser protocolChooser) {
        return new SocketTransportHandler(protocolChooser, (LogProvider)NullLogProvider.getInstance());
    }

    private static ChannelHandlerContext channelHandlerContextMock() {
        Channel channel = (Channel)Mockito.mock(Channel.class);
        ChannelHandlerContext context = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)context.channel()).thenReturn((Object)channel);
        Mockito.when((Object)channel.alloc()).thenReturn((Object)UnpooledByteBufAllocator.DEFAULT);
        Mockito.when((Object)context.alloc()).thenReturn((Object)UnpooledByteBufAllocator.DEFAULT);
        return context;
    }

    private ProtocolChooser protocolChooser(BoltStateMachine machine) {
        HashMap<Long, BiFunction<Channel, Boolean, BoltProtocol>> availableVersions = new HashMap<Long, BiFunction<Channel, Boolean, BoltProtocol>>();
        availableVersions.put(1L, (channel, isSecure) -> new BoltProtocolV1((BoltWorker)new SynchronousBoltWorker(machine), channel, (LogService)NullLogService.getInstance()));
        return new ProtocolChooser(availableVersions, false, true);
    }

    private ByteBuf handshake() {
        ByteBuf buf = UnpooledByteBufAllocator.DEFAULT.buffer();
        buf.writeInt(1616949271);
        buf.writeInt(1);
        buf.writeInt(0);
        buf.writeInt(0);
        buf.writeInt(0);
        return buf;
    }
}

