/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.socket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageWriter;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.RecordingByteChannel;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.packstream.BufferedChannelOutput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.SynchronousBoltWorker;
import org.neo4j.bolt.v1.transport.BoltProtocolV1;
import org.neo4j.bolt.v1.transport.socket.Chunker;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.util.HexPrinter;

public class FragmentedMessageDeliveryTest {
    private int chunkSize = 16;
    private int numFragments = 3;
    private RequestMessage[] messages = new RequestMessage[]{RunMessage.run("Mj\u00f6lnir")};

    @Test
    public void testFragmentedMessageDelivery() throws Throwable {
        byte[] unfragmented = this.serialize(this.chunkSize, this.messages);
        int n = unfragmented.length;
        for (int i = 1; i < n - 1; ++i) {
            for (int j = 1; j < n - i; ++j) {
                this.testPermutation(unfragmented, i, j, n - i - j);
            }
        }
    }

    private void testPermutation(byte[] unfragmented, int ... sizes) throws Exception {
        int pos = 0;
        ByteBuf[] fragments = new ByteBuf[sizes.length];
        for (int i = 0; i < sizes.length; ++i) {
            fragments[i] = Unpooled.wrappedBuffer((byte[])unfragmented, (int)pos, (int)sizes[i]);
            pos += sizes[i];
        }
        this.testPermutation(unfragmented, fragments);
    }

    private void testPermutation(byte[] unfragmented, ByteBuf[] fragments) throws Exception {
        BoltStateMachine machine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        Channel ch = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)ch.alloc()).thenReturn((Object)UnpooledByteBufAllocator.DEFAULT);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)ctx.channel()).thenReturn((Object)ch);
        BoltProtocolV1 protocol = new BoltProtocolV1((BoltWorker)new SynchronousBoltWorker(machine), ch, (LogService)NullLogService.getInstance());
        for (ByteBuf fragment : fragments) {
            fragment.readerIndex(0).retain();
            protocol.handle(ctx, fragment);
        }
        try {
            ((BoltStateMachine)Mockito.verify((Object)machine)).run((String)Matchers.eq((Object)"Mj\u00f6lnir"), Matchers.anyMapOf(String.class, Object.class), (BoltResponseHandler)Matchers.any(BoltResponseHandler.class));
        }
        catch (AssertionError e) {
            throw new AssertionError("Failed to handle fragmented delivery.\nMessages: " + Arrays.toString(this.messages) + "\nChunk size: " + this.chunkSize + "\nSerialized data delivered in fragments: " + this.describeFragments(fragments) + "\nUnfragmented data: " + HexPrinter.hex((byte[])unfragmented) + "\n", (Throwable)((Object)e));
        }
        finally {
            protocol.close();
        }
    }

    private String describeFragments(ByteBuf[] fragments) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fragments.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(fragments[i].capacity());
        }
        return sb.toString();
    }

    private byte[] serialize(int chunkSize, RequestMessage ... msgs) throws IOException {
        byte[][] serialized = new byte[msgs.length][];
        for (int i = 0; i < msgs.length; ++i) {
            RecordingByteChannel channel = new RecordingByteChannel();
            BoltRequestMessageWriter writer = new BoltRequestMessageWriter(new Neo4jPack.Packer((PackOutput)new BufferedChannelOutput(channel)), BoltResponseMessageWriter.NO_BOUNDARY_HOOK);
            writer.write(msgs[i]).flush();
            serialized[i] = channel.getBytes();
        }
        return Chunker.chunk(chunkSize, serialized);
    }
}

