/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.socket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.bolt.v1.transport.ChunkedOutput;

public class Chunker {
    private Chunker() {
    }

    public static byte[] chunk(int maxChunkSize, byte[][] messages) throws IOException {
        ByteBuffer outputBuffer = ByteBuffer.allocate(8192);
        Channel ch = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)ch.alloc()).thenReturn((Object)UnpooledByteBufAllocator.DEFAULT);
        Mockito.when((Object)ch.writeAndFlush(Matchers.any(), (ChannelPromise)Matchers.any(ChannelPromise.class))).then(inv -> {
            ByteBuf buf = (ByteBuf)inv.getArguments()[0];
            outputBuffer.limit(outputBuffer.position() + buf.readableBytes());
            buf.readBytes(outputBuffer);
            buf.release();
            return null;
        });
        ChunkedOutput out = new ChunkedOutput(ch, maxChunkSize + 2);
        for (byte[] message : messages) {
            out.writeBytes(message, 0, message.length);
            out.onMessageComplete();
        }
        out.flush();
        out.close();
        byte[] bytes = new byte[outputBuffer.limit()];
        outputBuffer.position(0);
        outputBuffer.get(bytes);
        return bytes;
    }
}

