/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.socket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.bolt.v1.transport.ChunkedOutput;
import org.neo4j.kernel.impl.util.HexPrinter;

public class ChunkedOutputTest {
    private final Channel ch = (Channel)Mockito.mock(Channel.class);
    private final ByteBuffer writtenData = ByteBuffer.allocate(1024);
    private ChunkedOutput out;

    @Test
    public void shouldNotNPE() throws Throwable {
        ExecutorService runner = Executors.newFixedThreadPool(4);
        runner.execute(() -> {
            try {
                for (int i = 0; i < 5; ++i) {
                    this.out.writeByte((byte)1).writeShort((short)2);
                    this.out.onMessageComplete();
                    this.out.flush();
                    Thread.sleep(ThreadLocalRandom.current().nextLong(5L));
                }
            }
            catch (IOException | InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        });
        for (int i = 0; i < 9; ++i) {
            runner.execute(() -> {
                try {
                    for (int j = 0; j < 5; ++j) {
                        this.out.flush();
                        Thread.sleep(ThreadLocalRandom.current().nextLong(5L));
                    }
                }
                catch (IOException | InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            });
        }
        runner.awaitTermination(2L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldChunkSingleMessage() throws Throwable {
        this.setupWriteAndFlush();
        this.out.writeByte((byte)1).writeShort((short)2);
        this.out.onMessageComplete();
        this.out.flush();
        MatcherAssert.assertThat((Object)this.writtenData.limit(), (Matcher)CoreMatchers.equalTo((Object)7));
        MatcherAssert.assertThat((Object)HexPrinter.hex((ByteBuffer)this.writtenData, (int)0, (int)7), (Matcher)CoreMatchers.equalTo((Object)"00 03 01 00 02 00 00"));
    }

    @Test
    public void shouldChunkMessageSpanningMultipleChunks() throws Throwable {
        this.setupWriteAndFlush();
        this.out.writeLong(1L).writeLong(2L).writeLong(3L);
        this.out.onMessageComplete();
        this.out.flush();
        MatcherAssert.assertThat((Object)this.writtenData.limit(), (Matcher)CoreMatchers.equalTo((Object)32));
        MatcherAssert.assertThat((Object)HexPrinter.hex((ByteBuffer)this.writtenData, (int)0, (int)32), (Matcher)CoreMatchers.equalTo((Object)"00 08 00 00 00 00 00 00    00 01 00 08 00 00 00 00    00 00 00 02 00 08 00 00    00 00 00 00 00 03 00 00"));
    }

    @Test
    public void shouldReserveSpaceForChunkHeaderWhenWriteDataToNewChunk() throws IOException {
        this.setupWriteAndFlush();
        this.out.writeBytes(new byte[10], 0, 10);
        this.out.onMessageComplete();
        this.out.writeShort((short)33);
        MatcherAssert.assertThat((Object)this.writtenData.limit(), (Matcher)CoreMatchers.equalTo((Object)14));
        MatcherAssert.assertThat((Object)HexPrinter.hex((ByteBuffer)this.writtenData, (int)0, (int)14), (Matcher)CoreMatchers.equalTo((Object)"00 0A 00 00 00 00 00 00    00 00 00 00 00 00"));
    }

    @Test
    public void shouldChunkDataWhoseSizeIsGreaterThanOutputBufferCapacity() throws IOException {
        this.setupWriteAndFlush();
        this.out.writeBytes(new byte[16], 0, 16);
        this.out.onMessageComplete();
        this.out.flush();
        MatcherAssert.assertThat((Object)this.writtenData.limit(), (Matcher)CoreMatchers.equalTo((Object)22));
        MatcherAssert.assertThat((Object)HexPrinter.hex((ByteBuffer)this.writtenData, (int)0, (int)22), (Matcher)CoreMatchers.equalTo((Object)"00 0E 00 00 00 00 00 00    00 00 00 00 00 00 00 00    00 02 00 00 00 00"));
    }

    @Test
    public void shouldNotThrowIfOutOfSyncFlush() throws Throwable {
        this.setupWriteAndFlush();
        this.out.writeLong(1L).writeLong(2L).writeLong(3L);
        this.out.onMessageComplete();
        this.out.flush();
        this.out.close();
        this.out.flush();
        MatcherAssert.assertThat((Object)this.writtenData.limit(), (Matcher)CoreMatchers.equalTo((Object)32));
        MatcherAssert.assertThat((Object)HexPrinter.hex((ByteBuffer)this.writtenData, (int)0, (int)32), (Matcher)CoreMatchers.equalTo((Object)"00 08 00 00 00 00 00 00    00 01 00 08 00 00 00 00    00 00 00 02 00 08 00 00    00 00 00 00 00 03 00 00"));
    }

    @Test
    public void shouldQueueWritesMadeWhileFlushing() throws Throwable {
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch finishLatch = new CountDownLatch(1);
        final AtomicBoolean parallelException = new AtomicBoolean(false);
        Mockito.when((Object)this.ch.writeAndFlush(Matchers.any(), (ChannelPromise)Matchers.any(ChannelPromise.class))).thenAnswer(invocation -> {
            startLatch.countDown();
            ByteBuf byteBuf = (ByteBuf)invocation.getArguments()[0];
            this.writtenData.limit(this.writtenData.position() + byteBuf.readableBytes());
            byteBuf.readBytes(this.writtenData);
            return null;
        });
        class ParallelWriter
        extends Thread {
            ParallelWriter() {
            }

            @Override
            public void run() {
                try {
                    startLatch.await();
                    ChunkedOutputTest.this.out.writeShort((short)2);
                    ChunkedOutputTest.this.out.flush();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    parallelException.set(true);
                }
                finally {
                    finishLatch.countDown();
                }
            }
        }
        new ParallelWriter().start();
        this.out.writeShort((short)1);
        this.out.flush();
        finishLatch.await();
        Assert.assertFalse((boolean)parallelException.get());
        MatcherAssert.assertThat((Object)this.writtenData.limit(), (Matcher)CoreMatchers.equalTo((Object)8));
        MatcherAssert.assertThat((Object)HexPrinter.hex((ByteBuffer)this.writtenData, (int)0, (int)8), (Matcher)CoreMatchers.equalTo((Object)"00 02 00 01 00 02 00 02"));
    }

    @Test
    public void shouldNotBeAbleToWriteAfterClose() throws Throwable {
        this.out.writeLong(1L).writeLong(2L).writeLong(3L);
        this.out.onMessageComplete();
        this.out.flush();
        this.out.close();
        try {
            this.out.writeShort((short)42);
            Assert.fail((String)"Should have thrown IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFlushOnClose() throws Throwable {
        this.setupWriteAndFlush();
        this.out.writeLong(1L).writeLong(2L).writeLong(3L);
        this.out.onMessageComplete();
        this.out.close();
        MatcherAssert.assertThat((Object)this.writtenData.limit(), (Matcher)CoreMatchers.equalTo((Object)32));
        MatcherAssert.assertThat((Object)HexPrinter.hex((ByteBuffer)this.writtenData, (int)0, (int)32), (Matcher)CoreMatchers.equalTo((Object)"00 08 00 00 00 00 00 00    00 01 00 08 00 00 00 00    00 00 00 02 00 08 00 00    00 00 00 00 00 03 00 00"));
    }

    private void setupWriteAndFlush() {
        Mockito.when((Object)this.ch.writeAndFlush(Matchers.any(), (ChannelPromise)Matchers.any(ChannelPromise.class))).thenAnswer(invocation -> {
            ByteBuf byteBuf = (ByteBuf)invocation.getArguments()[0];
            this.writtenData.limit(this.writtenData.position() + byteBuf.readableBytes());
            byteBuf.readBytes(this.writtenData);
            return null;
        });
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.ch.alloc()).thenReturn((Object)UnpooledByteBufAllocator.DEFAULT);
        this.out = new ChunkedOutput(this.ch, 16);
    }

    @After
    public void teardown() {
        this.out.close();
    }
}

