/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.socket;

import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.bolt.v1.transport.ChunkedInput;

public class ChunkedInputTest {
    @Test
    public void shouldExposeMultipleChunksAsCohesiveStream() throws Throwable {
        ChunkedInput ch = new ChunkedInput();
        ch.append(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        ch.append(Unpooled.wrappedBuffer((byte[])new byte[]{3}));
        ch.append(Unpooled.wrappedBuffer((byte[])new byte[]{4, 5}));
        byte[] bytes = new byte[5];
        ch.readBytes(bytes, 0, 5);
        MatcherAssert.assertThat((Object)bytes, (Matcher)CoreMatchers.equalTo((Object)new byte[]{1, 2, 3, 4, 5}));
    }

    @Test
    public void shouldReadIntoMisalignedDestinationBuffer() throws Throwable {
        byte[] bytes = new byte[3];
        ChunkedInput ch = new ChunkedInput();
        ch.append(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        ch.append(Unpooled.wrappedBuffer((byte[])new byte[]{3}));
        ch.append(Unpooled.wrappedBuffer((byte[])new byte[]{4}));
        ch.append(Unpooled.wrappedBuffer((byte[])new byte[]{5}));
        ch.append(Unpooled.wrappedBuffer((byte[])new byte[]{6, 7}));
        ch.readBytes(bytes, 0, 3);
        MatcherAssert.assertThat((Object)bytes, (Matcher)CoreMatchers.equalTo((Object)new byte[]{1, 2, 3}));
        ch.readBytes(bytes, 0, 3);
        MatcherAssert.assertThat((Object)bytes, (Matcher)CoreMatchers.equalTo((Object)new byte[]{4, 5, 6}));
        Arrays.fill(bytes, (byte)0);
        ch.readBytes(bytes, 0, 1);
        MatcherAssert.assertThat((Object)bytes, (Matcher)CoreMatchers.equalTo((Object)new byte[]{7, 0, 0}));
    }

    @Test
    public void shouldReadPartialChunk() throws Throwable {
        ChunkedInput ch = new ChunkedInput();
        ch.append(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        ch.append(Unpooled.wrappedBuffer((byte[])new byte[]{3}));
        ch.append(Unpooled.wrappedBuffer((byte[])new byte[]{4, 5}));
        byte[] bytes = new byte[5];
        ch.readBytes(bytes, 0, 5);
        MatcherAssert.assertThat((Object)bytes, (Matcher)CoreMatchers.equalTo((Object)new byte[]{1, 2, 3, 4, 5}));
    }

    @Test
    public void shouldHandleEmptyBuffer() throws Throwable {
        ChunkedInput ch = new ChunkedInput();
        ch.append(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        ch.append(Unpooled.wrappedBuffer((byte[])new byte[0]));
        ch.append(Unpooled.wrappedBuffer((byte[])new byte[]{3}));
        byte[] bytes = new byte[3];
        ch.readBytes(bytes, 0, 3);
        MatcherAssert.assertThat((Object)bytes, (Matcher)CoreMatchers.equalTo((Object)new byte[]{1, 2, 3}));
    }

    @Test
    public void shouldReadShortCorrectly() throws Throwable {
        ChunkedInput ch = new ChunkedInput();
        byte[] chunk0 = new byte[]{90};
        byte[] chunk1 = new byte[]{-91};
        ch.append(Unpooled.wrappedBuffer((byte[])chunk0));
        ch.append(Unpooled.wrappedBuffer((byte[])chunk1));
        short value = ch.readShort();
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)23205));
    }

    @Test
    public void shouldReadIntCorrectly() throws Throwable {
        ChunkedInput ch = new ChunkedInput();
        byte[] chunk0 = new byte[]{90, -1, -91};
        byte[] chunk1 = new byte[]{-91};
        ch.append(Unpooled.wrappedBuffer((byte[])chunk0));
        ch.append(Unpooled.wrappedBuffer((byte[])chunk1));
        int value = ch.readInt();
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)0x5AFFA5A5));
    }

    @Test
    public void shouldReadLongCorrectly() throws Throwable {
        ChunkedInput ch = new ChunkedInput();
        byte[] chunk0 = new byte[]{90, -1, -91};
        byte[] chunk1 = new byte[]{-91};
        byte[] chunk2 = new byte[]{-91, 0, 0, 0};
        ch.append(Unpooled.wrappedBuffer((byte[])chunk0));
        ch.append(Unpooled.wrappedBuffer((byte[])chunk1));
        ch.append(Unpooled.wrappedBuffer((byte[])chunk2));
        long value = ch.readLong();
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)6557141713331159040L));
    }

    @Test
    public void shouldReadDoubleCorrectly() throws Throwable {
        ChunkedInput ch = new ChunkedInput();
        byte[] bytes = new byte[8];
        ByteBuffer.wrap(bytes).putDouble(6.28);
        byte[] chunk0 = Arrays.copyOf(bytes, 6);
        byte[] chunk1 = Arrays.copyOfRange(bytes, 6, 8);
        ch.append(Unpooled.wrappedBuffer((byte[])chunk0));
        ch.append(Unpooled.wrappedBuffer((byte[])chunk1));
        double value = ch.readDouble();
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)6.28));
    }
}

