/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.v1.messaging.message.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.message.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.runtime.spi.StreamMatchers;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TestNotification;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SecureSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SecureWebSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.bolt.v1.transport.socket.client.WebSocketConnection;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.api.exceptions.Status;

@RunWith(value=Parameterized.class)
public class TransportSessionIT {
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), settings -> settings.put(GraphDatabaseSettings.auth_enabled.name(), "false"));
    @Parameterized.Parameter(value=0)
    public Factory<TransportConnection> cf;
    private HostnamePort address;
    private TransportConnection client;

    @Parameterized.Parameters
    public static Collection<Factory<TransportConnection>> transports() {
        return Arrays.asList(SocketConnection::new, WebSocketConnection::new, SecureSocketConnection::new, SecureWebSocketConnection::new);
    }

    @Before
    public void setup() {
        this.client = (TransportConnection)this.cf.newInstance();
        this.address = this.server.lookupDefaultConnector();
    }

    @After
    public void tearDown() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    @Test
    public void shouldNegotiateProtocolVersion() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
    }

    @Test
    public void shouldReturnNilOnNoApplicableVersion() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1337L, 0L, 0L, 0L));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 0}));
    }

    @Test
    public void shouldRunSimpleStatement() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", Collections.emptyMap()), RunMessage.run("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(CoreMatchers.allOf((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Arrays.asList("a", "a_squared"))), (Matcher)Matchers.hasKey((Object)"result_available_after"))), MessageMatchers.msgRecord(StreamMatchers.eqRecord(CoreMatchers.equalTo((Object)1L), CoreMatchers.equalTo((Object)1L))), MessageMatchers.msgRecord(StreamMatchers.eqRecord(CoreMatchers.equalTo((Object)2L), CoreMatchers.equalTo((Object)4L))), MessageMatchers.msgRecord(StreamMatchers.eqRecord(CoreMatchers.equalTo((Object)3L), CoreMatchers.equalTo((Object)9L))), MessageMatchers.msgSuccess(CoreMatchers.allOf((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"type"), (Matcher)CoreMatchers.equalTo((Object)"r")), (Matcher)Matchers.hasKey((Object)"result_consumed_after")))));
    }

    @Test
    public void shouldRespondWithMetadataToDiscardAll() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", Collections.emptyMap()), RunMessage.run("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"), DiscardAllMessage.discardAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(CoreMatchers.allOf((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Arrays.asList("a", "a_squared"))), (Matcher)Matchers.hasKey((Object)"result_available_after"))), MessageMatchers.msgSuccess(CoreMatchers.allOf((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"type"), (Matcher)CoreMatchers.equalTo((Object)"r")), (Matcher)Matchers.hasKey((Object)"result_consumed_after")))));
    }

    @Test
    public void shouldBeAbleToRunQueryAfterAckFailure() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", Collections.emptyMap()), RunMessage.run("QINVALID"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgFailure((Status)Status.Statement.SyntaxError, String.format("Invalid input 'Q': expected <init> (line 1, column 1 (offset: 0))%n\"QINVALID\"%n ^", new Object[0])), MessageMatchers.msgIgnored()));
        this.client.send(TransportTestUtil.chunk(AckFailureMessage.ackFailure(), RunMessage.run("RETURN 1"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgRecord(StreamMatchers.eqRecord(CoreMatchers.equalTo((Object)1L))), MessageMatchers.msgSuccess()));
    }

    @Test
    public void shouldRunProcedure() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", Collections.emptyMap()), RunMessage.run("CREATE (n:Test {age: 2}) RETURN n.age AS age"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(CoreMatchers.allOf((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("age"))), (Matcher)Matchers.hasKey((Object)"result_available_after"))), MessageMatchers.msgRecord(StreamMatchers.eqRecord(CoreMatchers.equalTo((Object)2L))), MessageMatchers.msgSuccess()));
        this.client.send(TransportTestUtil.chunk(RunMessage.run("CALL db.labels() YIELD label"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(CoreMatchers.allOf((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("label"))), (Matcher)Matchers.hasKey((Object)"result_available_after"))), MessageMatchers.msgRecord(StreamMatchers.eqRecord(Matchers.equalTo((Object)"Test"))), MessageMatchers.msgSuccess()));
    }

    @Test
    public void shouldHandleDeletedNodes() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", Collections.emptyMap()), RunMessage.run("CREATE (n:Test) DELETE n RETURN n"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(CoreMatchers.allOf((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("n"))), (Matcher)Matchers.hasKey((Object)"result_available_after")))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(this.bytes(0, 8, 177, 113, 145, 179, 78, 0, 144, 160, 0, 0)));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess()));
    }

    @Test
    public void shouldHandleDeletedRelationships() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", Collections.emptyMap()), RunMessage.run("CREATE ()-[r:T {prop: 42}]->() DELETE r RETURN r"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(CoreMatchers.allOf((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("r"))), (Matcher)Matchers.hasKey((Object)"result_available_after")))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(this.bytes(0, 11, 177, 113, 145, 181, 82, 0, 0, 1, 129, 84, 160, 0, 0)));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess()));
    }

    @Test
    public void shouldNotLeakStatsToNextStatement() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", Collections.emptyMap()), RunMessage.run("CREATE (n)"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()));
        this.client.send(TransportTestUtil.chunk(RunMessage.run("RETURN 1"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgRecord(StreamMatchers.eqRecord(CoreMatchers.equalTo((Object)1L))), MessageMatchers.msgSuccess(CoreMatchers.allOf((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"type"), (Matcher)CoreMatchers.equalTo((Object)"r")), (Matcher)Matchers.hasKey((Object)"result_consumed_after")))));
    }

    @Test
    public void shouldSendNotifications() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", Collections.emptyMap()), RunMessage.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.hasNotification(new TestNotification("Neo.ClientNotification.Statement.UnknownLabelWarning", "The provided label is not in the database.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", SeverityLevel.WARNING, new InputPosition(17, 1, 18)))));
    }

    @Test
    public void shouldFailNicelyOnPoints() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", Collections.emptyMap()), RunMessage.run("RETURN point({x:13, y:37, crs:'cartesian'}) as p"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(CoreMatchers.allOf((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("p"))), (Matcher)Matchers.hasKey((Object)"result_available_after"))), MessageMatchers.msgRecord(StreamMatchers.eqRecord(CoreMatchers.nullValue())), MessageMatchers.msgFailure((Status)Status.Request.Invalid, "Point is not yet supported as a return type in Bolt")));
    }

    private byte[] bytes(int ... ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    @Test
    public void shouldFailNicelyOnNullKeysInMap() throws Throwable {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Long> inner = new HashMap<String, Long>();
        inner.put(null, 42L);
        inner.put("foo", 1337L);
        params.put("p", inner);
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", Collections.emptyMap()), RunMessage.run("RETURN {p}", params), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgFailure((Status)Status.Request.Invalid, "Value `null` is not supported as key in maps, must be a non-nullable string."), MessageMatchers.msgIgnored()));
        this.client.send(TransportTestUtil.chunk(AckFailureMessage.ackFailure(), RunMessage.run("RETURN 1"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgRecord(StreamMatchers.eqRecord(CoreMatchers.equalTo((Object)1L))), MessageMatchers.msgSuccess()));
    }

    @Test
    public void shouldFailNicelyWhenDroppingUnknownIndex() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", Collections.emptyMap()), RunMessage.run("DROP INDEX on :Movie12345(id)"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgFailure((Status)Status.Schema.IndexDropFailed, "Unable to drop index on :Movie12345(id): No such INDEX ON :Movie12345(id)."), MessageMatchers.msgIgnored()));
    }
}

