/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.v1.messaging.BoltRequestMessage;
import org.neo4j.bolt.v1.messaging.RecordingByteChannel;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.BufferedChannelOutput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackStream;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SecureSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SecureWebSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.bolt.v1.transport.socket.client.WebSocketConnection;
import org.neo4j.function.Factory;
import org.neo4j.helpers.HostnamePort;

@RunWith(value=Parameterized.class)
public class TransportErrorIT {
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass());
    @Parameterized.Parameter
    public Factory<TransportConnection> cf;
    private HostnamePort address;
    private TransportConnection client;

    @Parameterized.Parameters
    public static Collection<Factory<TransportConnection>> transports() {
        return Arrays.asList(SocketConnection::new, WebSocketConnection::new, SecureSocketConnection::new, SecureWebSocketConnection::new);
    }

    @Before
    public void setup() {
        this.client = (TransportConnection)this.cf.newInstance();
        this.address = this.server.lookupDefaultConnector();
    }

    @After
    public void tearDown() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    @Test
    public void shouldHandleIncorrectFraming() throws Throwable {
        byte[] truncated = MessageMatchers.serialize(RunMessage.run("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"));
        truncated = Arrays.copyOf(truncated, truncated.length - 12);
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(32, new byte[][]{truncated}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldHandleMessagesWithIncorrectFields() throws Throwable {
        RecordingByteChannel rawData = new RecordingByteChannel();
        PackStream.Packer packer = new PackStream.Packer((PackOutput)new BufferedChannelOutput(rawData));
        packer.packStructHeader(2, BoltRequestMessage.RUN.signature());
        packer.pack("RETURN 1");
        packer.pack(1234L);
        packer.flush();
        byte[] invalidMessage = rawData.getBytes();
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(32, new byte[][]{invalidMessage}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldHandleUnknownMessages() throws Throwable {
        RecordingByteChannel rawData = new RecordingByteChannel();
        PackStream.Packer packer = new PackStream.Packer((PackOutput)new BufferedChannelOutput(rawData));
        packer.packStructHeader(1, (byte)102);
        packer.pack(1234L);
        packer.flush();
        byte[] invalidMessage = rawData.getBytes();
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(32, new byte[][]{invalidMessage}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldHandleUnknownMarkerBytes() throws Throwable {
        RecordingByteChannel rawData = new RecordingByteChannel();
        BufferedChannelOutput out = new BufferedChannelOutput(rawData);
        PackStream.Packer packer = new PackStream.Packer((PackOutput)out);
        packer.packStructHeader(2, BoltRequestMessage.RUN.signature());
        out.writeByte((byte)-60);
        out.flush();
        byte[] invalidMessage = rawData.getBytes();
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(32, new byte[][]{invalidMessage}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyDisconnects());
    }
}

