/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.v1.messaging.message.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.message.FailureMessage;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.ResetMessage;
import org.neo4j.bolt.v1.messaging.message.ResponseMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SecureSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SecureWebSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.bolt.v1.transport.socket.client.WebSocketConnection;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.internal.Version;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

@RunWith(value=Parameterized.class)
public class AuthenticationIT {
    protected EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    protected Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), this.getTestGraphDatabaseFactory(), (Supplier<FileSystemAbstraction>)this.fsRule, this.getSettingsFunction());
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fsRule).around((TestRule)this.server);
    @Parameterized.Parameter
    public Factory<TransportConnection> cf;
    private HostnamePort address;
    private TransportConnection client;
    private final String version = "Neo4j/" + Version.getNeo4jVersion();

    protected TestGraphDatabaseFactory getTestGraphDatabaseFactory() {
        return new TestGraphDatabaseFactory();
    }

    protected Consumer<Map<String, String>> getSettingsFunction() {
        return settings -> settings.put(GraphDatabaseSettings.auth_enabled.name(), "true");
    }

    @Parameterized.Parameters
    public static Collection<Factory<TransportConnection>> transports() {
        return Arrays.asList(SocketConnection::new, WebSocketConnection::new, SecureSocketConnection::new, SecureWebSocketConnection::new);
    }

    @Before
    public void setup() throws IOException {
        this.client = (TransportConnection)this.cf.newInstance();
        this.address = this.server.lookupDefaultConnector();
    }

    @After
    public void teardown() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    @Test
    public void shouldRespondWithCredentialsExpiredOnFirstUse() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(MapUtil.map((Object[])new Object[]{"credentials_expired", true, "server", this.version}))));
        this.verifyConnectionOpen();
    }

    private void verifyConnectionOpen() throws IOException {
        this.client.send(TransportTestUtil.chunk(ResetMessage.reset()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess()));
    }

    @Test
    public void shouldFailIfWrongCredentials() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "wrong", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, "The client is unauthorized due to authentication failure.")));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailIfWrongCredentialsFollowingSuccessfulLogin() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "new_credentials", "secret", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess()));
        this.reconnect();
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "secret", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess()));
        this.reconnect();
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "wrong", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, "The client is unauthorized due to authentication failure.")));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailIfMalformedAuthTokenWrongType() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", Collections.singletonList("neo4j"), "credentials", "neo4j", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, "Unsupported authentication token, the value associated with the key `principal` must be a String but was: ArrayList")));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailIfMalformedAuthTokenMissingKey() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "this-should-have-been-credentials", "neo4j", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, "Unsupported authentication token, missing key `credentials`")));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailIfMalformedAuthTokenMissingScheme() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, "Unsupported authentication token, missing key `scheme`")));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailIfMalformedAuthTokenUnknownScheme() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "unknown"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, "Unsupported authentication token, scheme 'unknown' is not supported.")));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailDifferentlyIfTooManyFailedAuthAttempts() throws Exception {
        long timeout = System.currentTimeMillis() + 30000L;
        FailureMsgMatcher failureMatcher = new FailureMsgMatcher();
        while (System.currentTimeMillis() < timeout && !failureMatcher.gotSpecialMessage()) {
            this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "WHAT_WAS_THE_PASSWORD_AGAIN", "scheme", "basic"}))));
            MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
            MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new Matcher[]{failureMatcher}));
            MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyDisconnects());
            this.reconnect();
        }
        MatcherAssert.assertThat((Object)failureMatcher.specialMessage.status(), (Matcher)CoreMatchers.equalTo((Object)Status.Security.AuthenticationRateLimit));
        MatcherAssert.assertThat((Object)failureMatcher.specialMessage.message(), (Matcher)CoreMatchers.containsString((String)"The client has provided incorrect authentication details too many times in a row."));
    }

    @Test
    public void shouldBeAbleToUpdateCredentials() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "new_credentials", "secret", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess()));
        this.reconnect();
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, "The client is unauthorized due to authentication failure.")));
        this.reconnect();
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "secret", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess()));
    }

    @Test
    public void shouldBeAuthenticatedAfterUpdatingCredentials() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "new_credentials", "secret", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess()));
        this.client.send(TransportTestUtil.chunk(RunMessage.run("MATCH (n) RETURN n"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()));
    }

    @Test
    public void shouldBeAbleToChangePasswordUsingBuiltInProcedure() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(MapUtil.map((Object[])new Object[]{"credentials_expired", true, "server", this.version}))));
        this.client.send(TransportTestUtil.chunk(RunMessage.run("CALL dbms.security.changePassword", Collections.singletonMap("password", "secret")), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess()));
        this.reconnect();
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, "The client is unauthorized due to authentication failure.")));
        this.reconnect();
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "secret", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess()));
    }

    @Test
    public void shouldBeAuthenticatedAfterChangePasswordUsingBuiltInProcedure() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(MapUtil.map((Object[])new Object[]{"credentials_expired", true, "server", this.version}))));
        this.client.send(TransportTestUtil.chunk(RunMessage.run("CALL dbms.security.changePassword", Collections.singletonMap("password", "secret")), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()));
        this.client.send(TransportTestUtil.chunk(RunMessage.run("MATCH (n) RETURN n"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()));
    }

    @Test
    public void shouldFailWhenReusingTheSamePassword() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(MapUtil.map((Object[])new Object[]{"credentials_expired", true, "server", this.version}))));
        this.client.send(TransportTestUtil.chunk(RunMessage.run("CALL dbms.security.changePassword", Collections.singletonMap("password", "neo4j")), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.General.InvalidArguments, "Old password and new password cannot be the same.")));
        this.client.send(TransportTestUtil.chunk(AckFailureMessage.ackFailure(), RunMessage.run("CALL dbms.security.changePassword", Collections.singletonMap("password", "abc")), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgIgnored(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()));
    }

    @Test
    public void shouldFailWhenSubmittingEmptyPassword() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(MapUtil.map((Object[])new Object[]{"credentials_expired", true, "server", this.version}))));
        this.client.send(TransportTestUtil.chunk(RunMessage.run("CALL dbms.security.changePassword", Collections.singletonMap("password", "")), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.General.InvalidArguments, "A password cannot be empty.")));
        this.client.send(TransportTestUtil.chunk(AckFailureMessage.ackFailure(), RunMessage.run("CALL dbms.security.changePassword", Collections.singletonMap("password", "abc")), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgIgnored(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()));
    }

    @Test
    public void shouldNotBeAbleToReadWhenPasswordChangeRequired() throws Throwable {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions(1L, 0L, 0L, 0L)).send(TransportTestUtil.chunk(InitMessage.init("TestClient/1.1", MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgSuccess(MapUtil.map((Object[])new Object[]{"credentials_expired", true, "server", this.version}))));
        this.client.send(TransportTestUtil.chunk(RunMessage.run("MATCH (n) RETURN n"), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.Security.CredentialsExpired, "The credentials you provided were valid, but must be changed before you can use this instance.")));
        MatcherAssert.assertThat((Object)this.client, TransportTestUtil.eventuallyDisconnects());
    }

    private void reconnect() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
        this.client = (TransportConnection)this.cf.newInstance();
    }

    class FailureMsgMatcher
    extends TypeSafeMatcher<ResponseMessage> {
        FailureMessage specialMessage;

        FailureMsgMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("FAILURE");
        }

        protected boolean matchesSafely(ResponseMessage t) {
            Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(FailureMessage.class));
            FailureMessage msg = (FailureMessage)t;
            if (!msg.status().equals(Status.Security.Unauthorized) || !msg.message().contains("The client is unauthorized due to authentication failure.")) {
                this.specialMessage = msg;
            }
            return true;
        }

        public boolean gotSpecialMessage() {
            return this.specialMessage != null;
        }
    }
}

