/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.transport.BoltProtocol;
import org.neo4j.bolt.transport.HandshakeOutcome;
import org.neo4j.bolt.transport.ProtocolChooser;

public class ProtocolChooserTest {
    private final Map<Long, BiFunction<Channel, Boolean, BoltProtocol>> available = new HashMap<Long, BiFunction<Channel, Boolean, BoltProtocol>>();
    private final BiFunction factory = (BiFunction)Mockito.mock(BiFunction.class);
    private final BoltProtocol protocol = (BoltProtocol)Mockito.mock(BoltProtocol.class);
    private final Channel ch = (Channel)Mockito.mock(Channel.class);

    @Test
    public void shouldChooseFirstAvailableProtocol() throws Throwable {
        Mockito.when(this.factory.apply(this.ch, true)).thenReturn((Object)this.protocol);
        this.available.put(1L, this.factory);
        ProtocolChooser chooser = new ProtocolChooser(this.available, false, true);
        HandshakeOutcome outcome = chooser.handleVersionHandshakeChunk(Unpooled.wrappedBuffer((byte[])new byte[]{96, 96, -80, 23, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}), this.ch);
        MatcherAssert.assertThat((Object)outcome, (Matcher)CoreMatchers.equalTo((Object)HandshakeOutcome.PROTOCOL_CHOSEN));
        MatcherAssert.assertThat((Object)chooser.chosenProtocol(), (Matcher)CoreMatchers.equalTo((Object)this.protocol));
    }

    @Test
    public void shouldHandleFragmentedMessage() throws Throwable {
        Mockito.when(this.factory.apply(this.ch, true)).thenReturn((Object)this.protocol);
        this.available.put(1L, this.factory);
        ProtocolChooser chooser = new ProtocolChooser(this.available, false, true);
        HandshakeOutcome firstOutcome = chooser.handleVersionHandshakeChunk(Unpooled.wrappedBuffer((byte[])new byte[]{96, 96}), this.ch);
        HandshakeOutcome secondOutcome = chooser.handleVersionHandshakeChunk(Unpooled.wrappedBuffer((byte[])new byte[]{-80, 23}), this.ch);
        HandshakeOutcome thirdOutcome = chooser.handleVersionHandshakeChunk(Unpooled.wrappedBuffer((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0}), this.ch);
        HandshakeOutcome fourthOutcome = chooser.handleVersionHandshakeChunk(Unpooled.wrappedBuffer((byte[])new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0}), this.ch);
        MatcherAssert.assertThat((Object)firstOutcome, (Matcher)CoreMatchers.equalTo((Object)HandshakeOutcome.PARTIAL_HANDSHAKE));
        MatcherAssert.assertThat((Object)secondOutcome, (Matcher)CoreMatchers.equalTo((Object)HandshakeOutcome.PARTIAL_HANDSHAKE));
        MatcherAssert.assertThat((Object)thirdOutcome, (Matcher)CoreMatchers.equalTo((Object)HandshakeOutcome.PARTIAL_HANDSHAKE));
        MatcherAssert.assertThat((Object)fourthOutcome, (Matcher)CoreMatchers.equalTo((Object)HandshakeOutcome.PROTOCOL_CHOSEN));
        MatcherAssert.assertThat((Object)chooser.chosenProtocol(), (Matcher)CoreMatchers.equalTo((Object)this.protocol));
    }

    @Test
    public void shouldHandleHandshakeFollowedByMessageInSameBuffer() throws Throwable {
        Mockito.when(this.factory.apply(this.ch, true)).thenReturn((Object)this.protocol);
        this.available.put(1L, this.factory);
        ProtocolChooser chooser = new ProtocolChooser(this.available, false, true);
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])new byte[]{96, 96, -80, 23, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4});
        HandshakeOutcome outcome = chooser.handleVersionHandshakeChunk(buffer, this.ch);
        MatcherAssert.assertThat((Object)outcome, (Matcher)CoreMatchers.equalTo((Object)HandshakeOutcome.PROTOCOL_CHOSEN));
        MatcherAssert.assertThat((Object)chooser.chosenProtocol(), (Matcher)CoreMatchers.equalTo((Object)this.protocol));
        MatcherAssert.assertThat((Object)buffer.readableBytes(), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void shouldHandleVersionBoundary() throws Throwable {
        long maxUnsignedInt32 = 0xFFFFFFFFL;
        Mockito.when(this.factory.apply(this.ch, true)).thenReturn((Object)this.protocol);
        this.available.put(maxUnsignedInt32, this.factory);
        ProtocolChooser chooser = new ProtocolChooser(this.available, false, true);
        HandshakeOutcome outcome = chooser.handleVersionHandshakeChunk(Unpooled.wrappedBuffer((byte[])new byte[]{96, 96, -80, 23, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}), this.ch);
        MatcherAssert.assertThat((Object)outcome, (Matcher)CoreMatchers.equalTo((Object)HandshakeOutcome.PROTOCOL_CHOSEN));
        MatcherAssert.assertThat((Object)chooser.chosenProtocol(), (Matcher)CoreMatchers.equalTo((Object)this.protocol));
    }

    @Test
    public void shouldFallBackToNoneProtocolIfNoMatch() throws Throwable {
        Mockito.when(this.factory.apply(this.ch, true)).thenReturn((Object)this.protocol);
        this.available.put(1L, (BiFunction<Channel, Boolean, BoltProtocol>)Mockito.mock(BiFunction.class));
        ProtocolChooser chooser = new ProtocolChooser(this.available, false, true);
        HandshakeOutcome outcome = chooser.handleVersionHandshakeChunk(Unpooled.wrappedBuffer((byte[])new byte[]{96, 96, -80, 23, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 4}), this.ch);
        MatcherAssert.assertThat((Object)outcome, (Matcher)CoreMatchers.equalTo((Object)HandshakeOutcome.NO_APPLICABLE_PROTOCOL));
        MatcherAssert.assertThat((Object)chooser.chosenProtocol(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldRejectIfInvalidHandshake() throws Throwable {
        Mockito.when(this.factory.apply(this.ch, true)).thenReturn((Object)this.protocol);
        this.available.put(1L, (BiFunction<Channel, Boolean, BoltProtocol>)Mockito.mock(BiFunction.class));
        ProtocolChooser chooser = new ProtocolChooser(this.available, false, true);
        HandshakeOutcome outcome = chooser.handleVersionHandshakeChunk(Unpooled.wrappedBuffer((byte[])new byte[]{-34, -83, -80, 23, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}), this.ch);
        MatcherAssert.assertThat((Object)outcome, (Matcher)CoreMatchers.equalTo((Object)HandshakeOutcome.INVALID_HANDSHAKE));
        MatcherAssert.assertThat((Object)chooser.chosenProtocol(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldRejectIfInsecureHandshake() throws Throwable {
        Mockito.when(this.factory.apply(this.ch, true)).thenReturn((Object)this.protocol);
        this.available.put(1L, (BiFunction<Channel, Boolean, BoltProtocol>)Mockito.mock(BiFunction.class));
        ProtocolChooser chooser = new ProtocolChooser(this.available, true, false);
        HandshakeOutcome outcome = chooser.handleVersionHandshakeChunk(Unpooled.wrappedBuffer((byte[])new byte[]{96, 96, -80, 23, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}), this.ch);
        MatcherAssert.assertThat((Object)outcome, (Matcher)CoreMatchers.equalTo((Object)HandshakeOutcome.INSECURE_HANDSHAKE));
        MatcherAssert.assertThat((Object)chooser.chosenProtocol(), (Matcher)CoreMatchers.nullValue());
    }
}

