/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.bolt.transport.NettyServer;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.PortBindException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.ConnectorPortRegister;

public class NettyServerTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldGivePortConflictErrorWithPortNumberInIt() throws Throwable {
        int port = 16000;
        try (ServerSocketChannel ignore = ServerSocketChannel.open().bind(new InetSocketAddress("localhost", port));){
            ListenSocketAddress address = new ListenSocketAddress("localhost", port);
            this.exception.expect(PortBindException.class);
            this.exception.expectMessage("Address localhost:16000 is already in use");
            Map initializersMap = MapUtil.genericMap((Object[])new Object[]{new BoltConnector("test"), this.protocolOnAddress(address)});
            new NettyServer((ThreadFactory)new NamedThreadFactory("mythreads"), initializersMap, new ConnectorPortRegister()).start();
        }
    }

    private NettyServer.ProtocolInitializer protocolOnAddress(final ListenSocketAddress address) {
        return new NettyServer.ProtocolInitializer(){

            public ChannelInitializer<SocketChannel> channelInitializer() {
                return new ChannelInitializer<SocketChannel>(){

                    public void initChannel(SocketChannel ch) throws Exception {
                    }
                };
            }

            public ListenSocketAddress address() {
                return address;
            }
        };
    }
}

