/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport;

import io.netty.buffer.Unpooled;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageRecorder;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.transport.BoltV1Dechunker;

public class BoltV1DechunkerTest {
    @Test
    public void shouldReadMessageWhenTheHeaderIsSplitAcrossChunks() throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int len = 1; len <= 32768; len <<= 1) {
            StringBuilder content = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                content.appendCodePoint(97 + ((Random)random).nextInt(25));
            }
            RunMessage run = RunMessage.run(content.toString());
            byte[] message = MessageMatchers.serialize(run);
            byte head1 = (byte)(message.length >> 8);
            byte head2 = (byte)(message.length & 0xFF);
            byte[] chunk2 = new byte[message.length + 3];
            chunk2[0] = head2;
            System.arraycopy(message, 0, chunk2, 1, message.length);
            BoltRequestMessageRecorder messages = new BoltRequestMessageRecorder();
            BoltV1Dechunker dechunker = new BoltV1Dechunker((BoltRequestMessageHandler)messages, () -> {});
            dechunker.handle(Unpooled.wrappedBuffer((byte[])new byte[]{head1}));
            Assert.assertTrue((String)("content length " + len + ": should be waiting for second chunk"), (boolean)messages.asList().isEmpty());
            dechunker.handle(Unpooled.wrappedBuffer((byte[])chunk2));
            Assert.assertEquals((String)("content length " + len + ": should have received message"), (long)1L, (long)messages.asList().size());
            Assert.assertEquals((Object)run, messages.asList().get(0));
        }
    }
}

