/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.Objects;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.SynchronousBoltWorker;
import org.neo4j.bolt.v1.transport.BoltProtocolV1;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class BoltProtocolV1Test {
    @Test
    public void shouldNotTalkToChannelDirectlyOnFatalError() throws Throwable {
        Channel outputChannel = BoltProtocolV1Test.newChannelMock();
        BoltStateMachine machine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        BoltProtocolV1 protocol = new BoltProtocolV1((BoltWorker)new SynchronousBoltWorker(machine), outputChannel, (LogService)NullLogService.getInstance());
        ((Channel)Mockito.verify((Object)outputChannel)).alloc();
        ByteBuf bomb = (ByteBuf)Mockito.mock(ByteBuf.class);
        ((ByteBuf)Mockito.doThrow(IOException.class).when((Object)bomb)).readableBytes();
        protocol.handle((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), bomb);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{outputChannel});
        ((BoltStateMachine)Mockito.verify((Object)machine)).close();
    }

    @Test
    public void closesInputAndOutput() {
        Channel outputChannel = (Channel)Mockito.mock(Channel.class);
        ByteBufAllocator allocator = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        ByteBuf buffer = (ByteBuf)Mockito.mock(ByteBuf.class);
        Mockito.when((Object)outputChannel.alloc()).thenReturn((Object)allocator);
        Mockito.when((Object)allocator.buffer(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyInt())).thenReturn((Object)buffer);
        BoltStateMachine machine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        BoltProtocolV1 protocol = new BoltProtocolV1((BoltWorker)new SynchronousBoltWorker(machine), outputChannel, (LogService)NullLogService.getInstance());
        protocol.close();
        ((BoltStateMachine)Mockito.verify((Object)machine)).close();
        ((ByteBuf)Mockito.verify((Object)buffer)).release();
    }

    @Test
    public void messageProcessingErrorIsLogged() throws IOException {
        RuntimeException error = new RuntimeException("Unexpected error!");
        ByteBuf data = BoltProtocolV1Test.newThrowingByteBuf(error);
        AssertableLogProvider assertableLogProvider = new AssertableLogProvider();
        SimpleLogService logService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)assertableLogProvider);
        BoltProtocolV1 protocol = new BoltProtocolV1((BoltWorker)Mockito.mock(BoltWorker.class), BoltProtocolV1Test.newChannelMock(), (LogService)logService);
        protocol.handle((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), data);
        assertableLogProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(BoltProtocolV1.class).error(Matchers.equalTo((Object)"Failed to handle incoming Bolt message. Connection will be closed."), Matchers.equalTo((Object)error))});
    }

    private static ByteBuf newThrowingByteBuf(RuntimeException exceptionToThrow) {
        Objects.requireNonNull(exceptionToThrow);
        ByteBuf buf = (ByteBuf)Mockito.mock(ByteBuf.class, invocation -> {
            throw exceptionToThrow;
        });
        ((ByteBuf)Mockito.doReturn((Object)true).when((Object)buf)).release();
        return buf;
    }

    private static Channel newChannelMock() {
        Channel channel = (Channel)Mockito.mock(Channel.class);
        ByteBufAllocator allocator = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)channel.alloc()).thenReturn((Object)allocator);
        return channel;
    }
}

