/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.spi;

import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.bolt.v1.runtime.spi.Record;

public class StreamMatchers {
    private StreamMatchers() {
    }

    public static Matcher<Record> eqRecord(final Matcher<?> ... expectedFieldValues) {
        return new TypeSafeMatcher<Record>(){

            protected boolean matchesSafely(Record item) {
                if (expectedFieldValues.length != item.fields().length) {
                    return false;
                }
                for (int i = 0; i < item.fields().length; ++i) {
                    if (expectedFieldValues[i].matches(item.fields()[i])) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("Record[").appendList(", fields=[", ",", "]", Arrays.asList(expectedFieldValues));
            }
        };
    }

    public static Matcher<BoltResult> equalsStream(final String[] fieldNames, final Matcher ... records) {
        return new TypeSafeMatcher<BoltResult>(){

            protected boolean matchesSafely(BoltResult item) {
                if (!Arrays.equals(fieldNames, item.fieldNames())) {
                    return false;
                }
                final Iterator<Matcher> expected = Arrays.asList(records).iterator();
                final AtomicBoolean matched = new AtomicBoolean(true);
                try {
                    item.accept(new BoltResult.Visitor(){

                        public void visit(Record record) {
                            if (!expected.hasNext() || !((Matcher)expected.next()).matches((Object)record)) {
                                matched.set(false);
                            }
                        }

                        public void addMetadata(String key, Object value) {
                        }
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return matched.get() && !expected.hasNext();
            }

            public void describeTo(Description description) {
                description.appendText("Stream[").appendValueList(" fieldNames=[", ",", "]", (Object[])fieldNames).appendList(", records=[", ",", "]", Arrays.asList(records));
            }
        };
    }
}

