/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.integration;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.v1.messaging.BoltResponseMessage;
import org.neo4j.bolt.v1.runtime.BoltConnectionDescriptor;
import org.neo4j.bolt.v1.runtime.BoltConnectionFatality;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.bolt.v1.runtime.integration.SessionRule;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.bolt.v1.runtime.spi.Record;
import org.neo4j.function.ThrowingAction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;

public class BoltConnectionIT {
    private static final Map<String, Object> EMPTY_PARAMS = Collections.emptyMap();
    private static final String USER_AGENT = "BoltConnectionIT/0.0";
    private static final BoltConnectionDescriptor CONNECTION_DESCRIPTOR = new BoltConnectionDescriptor((SocketAddress)new InetSocketAddress("<testClient>", 56789), (SocketAddress)new InetSocketAddress("<testServer>", 7468));
    @Rule
    public SessionRule env = new SessionRule();
    private static String[] IRIS_CLASS_NAMES = new String[]{"Iris-setosa", "Iris-versicolor", "Iris-virginica"};
    private static String IRIS_DATA = "sepal_length,sepal_width,petal_length,petal_width,class_name\n5.1,3.5,1.4,0.2,Iris-setosa\n4.9,3.0,1.4,0.2,Iris-setosa\n4.7,3.2,1.3,0.2,Iris-setosa\n4.6,3.1,1.5,0.2,Iris-setosa\n5.0,3.6,1.4,0.2,Iris-setosa\n5.4,3.9,1.7,0.4,Iris-setosa\n4.6,3.4,1.4,0.3,Iris-setosa\n5.0,3.4,1.5,0.2,Iris-setosa\n4.4,2.9,1.4,0.2,Iris-setosa\n4.9,3.1,1.5,0.1,Iris-setosa\n5.4,3.7,1.5,0.2,Iris-setosa\n4.8,3.4,1.6,0.2,Iris-setosa\n4.8,3.0,1.4,0.1,Iris-setosa\n4.3,3.0,1.1,0.1,Iris-setosa\n5.8,4.0,1.2,0.2,Iris-setosa\n5.7,4.4,1.5,0.4,Iris-setosa\n5.4,3.9,1.3,0.4,Iris-setosa\n5.1,3.5,1.4,0.3,Iris-setosa\n5.7,3.8,1.7,0.3,Iris-setosa\n5.1,3.8,1.5,0.3,Iris-setosa\n5.4,3.4,1.7,0.2,Iris-setosa\n5.1,3.7,1.5,0.4,Iris-setosa\n4.6,3.6,1.0,0.2,Iris-setosa\n5.1,3.3,1.7,0.5,Iris-setosa\n4.8,3.4,1.9,0.2,Iris-setosa\n5.0,3.0,1.6,0.2,Iris-setosa\n5.0,3.4,1.6,0.4,Iris-setosa\n5.2,3.5,1.5,0.2,Iris-setosa\n5.2,3.4,1.4,0.2,Iris-setosa\n4.7,3.2,1.6,0.2,Iris-setosa\n4.8,3.1,1.6,0.2,Iris-setosa\n5.4,3.4,1.5,0.4,Iris-setosa\n5.2,4.1,1.5,0.1,Iris-setosa\n5.5,4.2,1.4,0.2,Iris-setosa\n4.9,3.1,1.5,0.2,Iris-setosa\n5.0,3.2,1.2,0.2,Iris-setosa\n5.5,3.5,1.3,0.2,Iris-setosa\n4.9,3.6,1.4,0.1,Iris-setosa\n4.4,3.0,1.3,0.2,Iris-setosa\n5.1,3.4,1.5,0.2,Iris-setosa\n5.0,3.5,1.3,0.3,Iris-setosa\n4.5,2.3,1.3,0.3,Iris-setosa\n4.4,3.2,1.3,0.2,Iris-setosa\n5.0,3.5,1.6,0.6,Iris-setosa\n5.1,3.8,1.9,0.4,Iris-setosa\n4.8,3.0,1.4,0.3,Iris-setosa\n5.1,3.8,1.6,0.2,Iris-setosa\n4.6,3.2,1.4,0.2,Iris-setosa\n5.3,3.7,1.5,0.2,Iris-setosa\n5.0,3.3,1.4,0.2,Iris-setosa\n7.0,3.2,4.7,1.4,Iris-versicolor\n6.4,3.2,4.5,1.5,Iris-versicolor\n6.9,3.1,4.9,1.5,Iris-versicolor\n5.5,2.3,4.0,1.3,Iris-versicolor\n6.5,2.8,4.6,1.5,Iris-versicolor\n5.7,2.8,4.5,1.3,Iris-versicolor\n6.3,3.3,4.7,1.6,Iris-versicolor\n4.9,2.4,3.3,1.0,Iris-versicolor\n6.6,2.9,4.6,1.3,Iris-versicolor\n5.2,2.7,3.9,1.4,Iris-versicolor\n5.0,2.0,3.5,1.0,Iris-versicolor\n5.9,3.0,4.2,1.5,Iris-versicolor\n6.0,2.2,4.0,1.0,Iris-versicolor\n6.1,2.9,4.7,1.4,Iris-versicolor\n5.6,2.9,3.6,1.3,Iris-versicolor\n6.7,3.1,4.4,1.4,Iris-versicolor\n5.6,3.0,4.5,1.5,Iris-versicolor\n5.8,2.7,4.1,1.0,Iris-versicolor\n6.2,2.2,4.5,1.5,Iris-versicolor\n5.6,2.5,3.9,1.1,Iris-versicolor\n5.9,3.2,4.8,1.8,Iris-versicolor\n6.1,2.8,4.0,1.3,Iris-versicolor\n6.3,2.5,4.9,1.5,Iris-versicolor\n6.1,2.8,4.7,1.2,Iris-versicolor\n6.4,2.9,4.3,1.3,Iris-versicolor\n6.6,3.0,4.4,1.4,Iris-versicolor\n6.8,2.8,4.8,1.4,Iris-versicolor\n6.7,3.0,5.0,1.7,Iris-versicolor\n6.0,2.9,4.5,1.5,Iris-versicolor\n5.7,2.6,3.5,1.0,Iris-versicolor\n5.5,2.4,3.8,1.1,Iris-versicolor\n5.5,2.4,3.7,1.0,Iris-versicolor\n5.8,2.7,3.9,1.2,Iris-versicolor\n6.0,2.7,5.1,1.6,Iris-versicolor\n5.4,3.0,4.5,1.5,Iris-versicolor\n6.0,3.4,4.5,1.6,Iris-versicolor\n6.7,3.1,4.7,1.5,Iris-versicolor\n6.3,2.3,4.4,1.3,Iris-versicolor\n5.6,3.0,4.1,1.3,Iris-versicolor\n5.5,2.5,4.0,1.3,Iris-versicolor\n5.5,2.6,4.4,1.2,Iris-versicolor\n6.1,3.0,4.6,1.4,Iris-versicolor\n5.8,2.6,4.0,1.2,Iris-versicolor\n5.0,2.3,3.3,1.0,Iris-versicolor\n5.6,2.7,4.2,1.3,Iris-versicolor\n5.7,3.0,4.2,1.2,Iris-versicolor\n5.7,2.9,4.2,1.3,Iris-versicolor\n6.2,2.9,4.3,1.3,Iris-versicolor\n5.1,2.5,3.0,1.1,Iris-versicolor\n5.7,2.8,4.1,1.3,Iris-versicolor\n6.3,3.3,6.0,2.5,Iris-virginica\n5.8,2.7,5.1,1.9,Iris-virginica\n7.1,3.0,5.9,2.1,Iris-virginica\n6.3,2.9,5.6,1.8,Iris-virginica\n6.5,3.0,5.8,2.2,Iris-virginica\n7.6,3.0,6.6,2.1,Iris-virginica\n4.9,2.5,4.5,1.7,Iris-virginica\n7.3,2.9,6.3,1.8,Iris-virginica\n6.7,2.5,5.8,1.8,Iris-virginica\n7.2,3.6,6.1,2.5,Iris-virginica\n6.5,3.2,5.1,2.0,Iris-virginica\n6.4,2.7,5.3,1.9,Iris-virginica\n6.8,3.0,5.5,2.1,Iris-virginica\n5.7,2.5,5.0,2.0,Iris-virginica\n5.8,2.8,5.1,2.4,Iris-virginica\n6.4,3.2,5.3,2.3,Iris-virginica\n6.5,3.0,5.5,1.8,Iris-virginica\n7.7,3.8,6.7,2.2,Iris-virginica\n7.7,2.6,6.9,2.3,Iris-virginica\n6.0,2.2,5.0,1.5,Iris-virginica\n6.9,3.2,5.7,2.3,Iris-virginica\n5.6,2.8,4.9,2.0,Iris-virginica\n7.7,2.8,6.7,2.0,Iris-virginica\n6.3,2.7,4.9,1.8,Iris-virginica\n6.7,3.3,5.7,2.1,Iris-virginica\n7.2,3.2,6.0,1.8,Iris-virginica\n6.2,2.8,4.8,1.8,Iris-virginica\n6.1,3.0,4.9,1.8,Iris-virginica\n6.4,2.8,5.6,2.1,Iris-virginica\n7.2,3.0,5.8,1.6,Iris-virginica\n7.4,2.8,6.1,1.9,Iris-virginica\n7.9,3.8,6.4,2.0,Iris-virginica\n6.4,2.8,5.6,2.2,Iris-virginica\n6.3,2.8,5.1,1.5,Iris-virginica\n6.1,2.6,5.6,1.4,Iris-virginica\n7.7,3.0,6.1,2.3,Iris-virginica\n6.3,3.4,5.6,2.4,Iris-virginica\n6.4,3.1,5.5,1.8,Iris-virginica\n6.0,3.0,4.8,1.8,Iris-virginica\n6.9,3.1,5.4,2.1,Iris-virginica\n6.7,3.1,5.6,2.4,Iris-virginica\n6.9,3.1,5.1,2.3,Iris-virginica\n5.8,2.7,5.1,1.9,Iris-virginica\n6.8,3.2,5.9,2.3,Iris-virginica\n6.7,3.3,5.7,2.5,Iris-virginica\n6.7,3.0,5.2,2.3,Iris-virginica\n6.3,2.5,5.0,1.9,Iris-virginica\n6.5,3.0,5.2,2.0,Iris-virginica\n6.2,3.4,5.4,2.3,Iris-virginica\n5.9,3.0,5.1,1.8,Iris-virginica\n\n";

    @Test
    public void shouldCloseConnectionAckFailureBeforeInit() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection((ThrowingAction<BoltConnectionFatality>)((ThrowingAction)() -> machine.ackFailure((BoltResponseHandler)recorder)));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
    }

    @Test
    public void shouldCloseConnectionResetBeforeInit() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection((ThrowingAction<BoltConnectionFatality>)((ThrowingAction)() -> machine.reset((BoltResponseHandler)recorder)));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
    }

    @Test
    public void shouldCloseConnectionOnRunBeforeInit() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection((ThrowingAction<BoltConnectionFatality>)((ThrowingAction)() -> machine.run("RETURN 1", MapUtil.map((Object[])new Object[0]), (BoltResponseHandler)recorder)));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
    }

    @Test
    public void shouldCloseConnectionOnDiscardAllBeforeInit() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection((ThrowingAction<BoltConnectionFatality>)((ThrowingAction)() -> machine.discardAll((BoltResponseHandler)recorder)));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
    }

    @Test
    public void shouldCloseConnectionOnPullAllBeforeInit() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection((ThrowingAction<BoltConnectionFatality>)((ThrowingAction)() -> machine.pullAll((BoltResponseHandler)recorder)));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
    }

    @Test
    public void shouldExecuteStatement() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run("CREATE (n {k:'k'}) RETURN n.k", EMPTY_PARAMS, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        recorder.reset();
        machine.pullAll((BoltResponseHandler)recorder);
        recorder.nextResponse().assertRecord(0, "k");
    }

    @Test
    public void shouldSucceedOn__run__pullAll__run() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        machine.run("RETURN 1", EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.pullAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run("RETURN 1", EMPTY_PARAMS, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
    }

    @Test
    public void shouldSucceedOn__run__discardAll__run() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        machine.run("RETURN 1", EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run("RETURN 1", EMPTY_PARAMS, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
    }

    @Test
    public void shouldSucceedOn__run_BEGIN__pullAll__run_COMMIT__pullALL__run_COMMIT() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run("BEGIN", EMPTY_PARAMS, (BoltResponseHandler)recorder);
        machine.pullAll((BoltResponseHandler)recorder);
        machine.run("COMMIT", EMPTY_PARAMS, (BoltResponseHandler)recorder);
        machine.pullAll((BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        recorder.reset();
        machine.run("BEGIN", EMPTY_PARAMS, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
    }

    @Test
    public void shouldFailOn__run__run() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        machine.run("RETURN 1", EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection((ThrowingAction<BoltConnectionFatality>)((ThrowingAction)() -> machine.run("RETURN 1", EMPTY_PARAMS, (BoltResponseHandler)recorder)));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
    }

    @Test
    public void shouldFailOn__pullAll__pullAll() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        machine.run("RETURN 1", EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.pullAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection((ThrowingAction<BoltConnectionFatality>)((ThrowingAction)() -> machine.pullAll((BoltResponseHandler)recorder)));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
    }

    @Test
    public void shouldFailOn__pullAll__discardAll() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        machine.run("RETURN 1", EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.pullAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection((ThrowingAction<BoltConnectionFatality>)((ThrowingAction)() -> machine.discardAll((BoltResponseHandler)recorder)));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
    }

    @Test
    public void shouldFailOn__discardAll__discardAll() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        machine.run("RETURN 1", EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection((ThrowingAction<BoltConnectionFatality>)((ThrowingAction)() -> machine.discardAll((BoltResponseHandler)recorder)));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
    }

    @Test
    public void shouldFailOn__discardAll__pullAll() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        machine.run("RETURN 1", EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection((ThrowingAction<BoltConnectionFatality>)((ThrowingAction)() -> machine.pullAll((BoltResponseHandler)recorder)));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
    }

    @Test
    public void shouldHandleImplicitCommitFailure() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        machine.run("CREATE (n:Victim)-[:REL]->()", EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run("MATCH (n:Victim) DELETE n", EMPTY_PARAMS, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        recorder.reset();
        machine.discardAll((BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Schema.ConstraintValidationFailed));
    }

    @Test
    public void shouldAllowUserControlledRollbackOnExplicitTxFailure() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(new BoltConnectionDescriptor((SocketAddress)new InetSocketAddress("bolt-test", 56789), (SocketAddress)new InetSocketAddress("test-server", 7468)));
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        machine.run("BEGIN", EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.run("CREATE (n:Victim)-[:REL]->()", EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run("this is not valid syntax", EMPTY_PARAMS, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Statement.SyntaxError));
        recorder.reset();
        machine.ackFailure((BoltResponseHandler)recorder);
        machine.run("ROLLBACK", EMPTY_PARAMS, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
    }

    @Test
    public void shouldHandleFailureDuringResultPublishing() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        final CountDownLatch pullAllCallbackCalled = new CountDownLatch(1);
        final AtomicReference error = new AtomicReference();
        machine.run("RETURN 1", EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.pullAll(new BoltResponseHandler(){

            public void onStart() {
            }

            public void onRecords(BoltResult result, boolean pull) throws Exception {
                throw new RuntimeException("Ooopsies!");
            }

            public void onMetadata(String key, Object value) {
            }

            public void markFailed(Neo4jError err) {
                error.set(err);
                pullAllCallbackCalled.countDown();
            }

            public void markIgnored() {
            }

            public void onFinish() {
            }
        });
        Assert.assertTrue((boolean)pullAllCallbackCalled.await(30L, TimeUnit.SECONDS));
        Neo4jError err = (Neo4jError)error.get();
        MatcherAssert.assertThat((Object)err.status(), (Matcher)CoreMatchers.equalTo((Object)Status.General.UnknownError));
        MatcherAssert.assertThat((Object)err.message(), (Matcher)CoreMatchers.containsString((String)"Ooopsies!"));
    }

    @Test
    public void shouldBeAbleToCleanlyRunMultipleSessionsInSingleThread() throws Throwable {
        BoltStateMachine firstMachine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        firstMachine.init(USER_AGENT, Collections.emptyMap(), null);
        BoltStateMachine secondMachine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        secondMachine.init(USER_AGENT, Collections.emptyMap(), null);
        this.runAndPull(firstMachine, "BEGIN");
        Object[] stream = this.runAndPull(secondMachine, "CREATE (a:Person) RETURN id(a)");
        long id = (Long)((Record)stream[0]).fields()[0];
        this.runAndPull(firstMachine, "ROLLBACK");
        stream = this.runAndPull(secondMachine, "MATCH (a:Person) WHERE id(a) = " + id + " RETURN COUNT(*)");
        MatcherAssert.assertThat((Object)((Record)stream[0]).fields()[0], (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldSupportUsingPeriodicCommitInSession() throws Exception {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("csvFileUrl", this.createLocalIrisData(machine));
        long txIdBeforeQuery = this.env.lastClosedTxId();
        long batch = 40L;
        Object[] result = this.runAndPull(machine, "USING PERIODIC COMMIT " + batch + "\nLOAD CSV WITH HEADERS FROM {csvFileUrl} AS l\nMATCH (c:Class {name: l.class_name})\nCREATE (s:Sample {sepal_length: l.sepal_length, sepal_width: l.sepal_width, petal_length: l.petal_length, petal_width: l.petal_width})\nCREATE (c)<-[:HAS_CLASS]-(s)\nRETURN count(*) AS c", params);
        MatcherAssert.assertThat((Object)result.length, (Matcher)CoreMatchers.equalTo((Object)1));
        Record record = (Record)result[0];
        Object[] fields = record.fields();
        MatcherAssert.assertThat((Object)fields.length, (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)fields[0], (Matcher)CoreMatchers.equalTo((Object)150L));
        long tokensCommits = 7L;
        long commits = (long)(IRIS_DATA.split("\n").length - 1) / batch;
        long txId = this.env.lastClosedTxId();
        Assert.assertEquals((long)(tokensCommits + commits + txIdBeforeQuery), (long)txId);
    }

    @Test
    public void shouldNotSupportUsingPeriodicCommitInTransaction() throws Exception {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("csvFileUrl", this.createLocalIrisData(machine));
        this.runAndPull(machine, "BEGIN");
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run("USING PERIODIC COMMIT 40\nLOAD CSV WITH HEADERS FROM {csvFileUrl} AS l\nMATCH (c:Class {name: l.class_name})\nCREATE (s:Sample {sepal_length: l.sepal_length, sepal_width: l.sepal_width, petal_length: l.petal_length, petal_width: l.petal_width})\nCREATE (c)<-[:HAS_CLASS]-(s)\nRETURN count(*) AS c", params, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Statement.SemanticError));
    }

    @Test
    public void shouldCloseTransactionOnCommit() throws Exception {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        this.runAndPull(machine, "BEGIN");
        this.runAndPull(machine, "RETURN 1");
        this.runAndPull(machine, "COMMIT");
        Assert.assertFalse((boolean)machine.statementProcessor().hasTransaction());
    }

    @Test
    public void shouldCloseTransactionEvenIfCommitFails() throws Exception {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        this.runAndPull(machine, "BEGIN");
        this.runAndPull(machine, "X", MapUtil.map((Object[])new Object[0]), BoltResponseMessage.IGNORED);
        machine.ackFailure((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        this.runAndPull(machine, "COMMIT", MapUtil.map((Object[])new Object[0]), BoltResponseMessage.IGNORED);
        machine.ackFailure((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        Assert.assertFalse((boolean)machine.statementProcessor().hasTransaction());
    }

    @Test
    public void shouldCloseTransactionOnRollback() throws Exception {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        this.runAndPull(machine, "BEGIN");
        this.runAndPull(machine, "RETURN 1");
        this.runAndPull(machine, "ROLLBACK");
        Assert.assertFalse((boolean)machine.statementProcessor().hasTransaction());
    }

    @Test
    public void shouldCloseTransactionOnRollbackAfterFailure() throws Exception {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        this.runAndPull(machine, "BEGIN");
        this.runAndPull(machine, "X", MapUtil.map((Object[])new Object[0]), BoltResponseMessage.IGNORED);
        machine.ackFailure((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        this.runAndPull(machine, "ROLLBACK");
        Assert.assertFalse((boolean)machine.statementProcessor().hasTransaction());
    }

    @Test
    public void shouldAllowNewTransactionAfterFailure() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        this.runAndPull(machine, "BEGIN");
        machine.run("invalid", EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.reset((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        this.runAndPull(machine, "BEGIN");
        Object[] stream = this.runAndPull(machine, "RETURN 1");
        MatcherAssert.assertThat((Object)((Record)stream[0]).fields()[0], (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    private String createLocalIrisData(BoltStateMachine machine) throws Exception {
        for (String className : IRIS_CLASS_NAMES) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("className", className);
            this.runAndPull(machine, "CREATE (c:Class {name: {className}}) RETURN c", params);
        }
        return this.env.putTmpFile("iris", ".csv", IRIS_DATA).toExternalForm();
    }

    private Object[] runAndPull(BoltStateMachine machine, String statement) throws Exception {
        return this.runAndPull(machine, statement, EMPTY_PARAMS, BoltResponseMessage.SUCCESS);
    }

    private Object[] runAndPull(BoltStateMachine machine, String statement, Map<String, Object> params) throws Exception {
        return this.runAndPull(machine, statement, params, BoltResponseMessage.SUCCESS);
    }

    private Object[] runAndPull(BoltStateMachine machine, String statement, Map<String, Object> params, BoltResponseMessage expectedResponse) throws Exception {
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run(statement, params, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.pullAll((BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assert.assertEquals((Object)expectedResponse, (Object)response.message());
        return response.records();
    }
}

