/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.integration;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.v1.runtime.BoltConnectionDescriptor;
import org.neo4j.bolt.v1.runtime.BoltConnectionFatality;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.integration.SessionRule;
import org.neo4j.function.ThrowingAction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.internal.Version;

public class BoltConnectionAuthIT {
    private static final String USER_AGENT = "BoltConnectionAuthIT/0.0";
    private static final BoltConnectionDescriptor CONNECTION_DESCRIPTOR = new BoltConnectionDescriptor((SocketAddress)new InetSocketAddress("testClient", 56789), (SocketAddress)new InetSocketAddress("testServer", 7468));
    @Rule
    public SessionRule env = new SessionRule().withAuthEnabled(true);

    @Test
    public void shouldGiveCredentialsExpiredStatusOnExpiredCredentials() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.init(USER_AGENT, MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j", "credentials", "neo4j"}), (BoltResponseHandler)recorder);
        machine.run("CREATE ()", MapUtil.map((Object[])new Object[0]), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithMetadata("credentials_expired", true));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Security.CredentialsExpired));
    }

    @Test
    public void shouldGiveKernelVersionOnInit() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        String version = "Neo4j/" + Version.getNeo4jVersion();
        machine.init(USER_AGENT, MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j", "credentials", "neo4j"}), (BoltResponseHandler)recorder);
        machine.run("CREATE ()", MapUtil.map((Object[])new Object[0]), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithMetadata("server", version));
    }

    @Test
    public void shouldCloseConnectionAfterAuthenticationFailure() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection((ThrowingAction<BoltConnectionFatality>)((ThrowingAction)() -> machine.init(USER_AGENT, MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j", "credentials", "j4oen"}), (BoltResponseHandler)recorder)));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Security.Unauthorized));
    }

    @Test
    public void shouldBeAbleToActOnSessionWhenUpdatingCredentials() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(CONNECTION_DESCRIPTOR);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.init(USER_AGENT, MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j", "credentials", "neo4j", "new_credentials", "secret"}), (BoltResponseHandler)recorder);
        machine.run("CREATE ()", MapUtil.map((Object[])new Object[0]), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
    }
}

