/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.concurrent;

import org.apache.commons.lang3.mutable.MutableBoolean;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.v1.runtime.BoltConnectionAuthFatality;
import org.neo4j.bolt.v1.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.concurrent.RunnableBoltWorker;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.logging.AssertableLogProvider;

public class RunnableBoltWorkerTest {
    private AssertableLogProvider internalLog;
    private AssertableLogProvider userLog;
    private LogService logService;
    private BoltStateMachine machine;

    @Before
    public void setup() {
        this.internalLog = new AssertableLogProvider();
        this.userLog = new AssertableLogProvider();
        this.logService = (LogService)Mockito.mock(LogService.class);
        Mockito.when((Object)this.logService.getUserLogProvider()).thenReturn((Object)this.userLog);
        Mockito.when((Object)this.logService.getUserLog(RunnableBoltWorker.class)).thenReturn((Object)this.userLog.getLog(RunnableBoltWorker.class));
        Mockito.when((Object)this.logService.getInternalLogProvider()).thenReturn((Object)this.internalLog);
        Mockito.when((Object)this.logService.getInternalLog(RunnableBoltWorker.class)).thenReturn((Object)this.internalLog.getLog(RunnableBoltWorker.class));
        this.machine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        Mockito.when((Object)this.machine.key()).thenReturn((Object)"test-session");
    }

    @Test
    public void shouldExecuteWorkWhenRun() throws Throwable {
        RunnableBoltWorker worker = new RunnableBoltWorker(this.machine, (LogService)NullLogService.getInstance());
        worker.enqueue(s -> s.run("Hello, world!", null, null));
        worker.enqueue(s -> worker.halt());
        worker.run();
        ((BoltStateMachine)Mockito.verify((Object)this.machine)).run("Hello, world!", null, null);
        ((BoltStateMachine)Mockito.verify((Object)this.machine)).terminate();
        ((BoltStateMachine)Mockito.verify((Object)this.machine)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.machine});
    }

    @Test
    public void errorThrownDuringExecutionShouldCauseSessionClose() throws Throwable {
        RunnableBoltWorker worker = new RunnableBoltWorker(this.machine, (LogService)NullLogService.getInstance());
        worker.enqueue(s -> {
            throw new RuntimeException("It didn't work out.");
        });
        worker.run();
        ((BoltStateMachine)Mockito.verify((Object)this.machine)).close();
    }

    @Test
    public void authExceptionShouldNotBeLoggedHere() throws Throwable {
        RunnableBoltWorker worker = new RunnableBoltWorker(this.machine, this.logService);
        worker.enqueue(s -> {
            throw new BoltConnectionAuthFatality("fatality");
        });
        worker.run();
        ((BoltStateMachine)Mockito.verify((Object)this.machine)).close();
        this.internalLog.assertNone(AssertableLogProvider.inLog(RunnableBoltWorker.class).any());
        this.userLog.assertNone(AssertableLogProvider.inLog(RunnableBoltWorker.class).any());
    }

    @Test
    public void protocolBreachesShouldBeLoggedWithStackTraces() throws Throwable {
        BoltProtocolBreachFatality error = new BoltProtocolBreachFatality("protocol breach fatality");
        RunnableBoltWorker worker = new RunnableBoltWorker(this.machine, this.logService);
        worker.enqueue(s -> {
            throw error;
        });
        worker.run();
        ((BoltStateMachine)Mockito.verify((Object)this.machine)).close();
        this.internalLog.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(RunnableBoltWorker.class).error(Matchers.equalTo((Object)"Bolt protocol breach in session 'test-session'"), Matchers.equalTo((Object)error))});
        this.userLog.assertNone(AssertableLogProvider.inLog(RunnableBoltWorker.class).any());
    }

    @Test
    public void haltShouldTerminateButNotCloseTheStateMachine() {
        RunnableBoltWorker worker = new RunnableBoltWorker(this.machine, this.logService);
        worker.halt();
        ((BoltStateMachine)Mockito.verify((Object)this.machine)).terminate();
        ((BoltStateMachine)Mockito.verify((Object)this.machine, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void workerCanBeHaltedMultipleTimes() {
        RunnableBoltWorker worker = new RunnableBoltWorker(this.machine, this.logService);
        worker.halt();
        worker.halt();
        worker.halt();
        ((BoltStateMachine)Mockito.verify((Object)this.machine, (VerificationMode)Mockito.times((int)3))).terminate();
        ((BoltStateMachine)Mockito.verify((Object)this.machine, (VerificationMode)Mockito.never())).close();
        worker.run();
        ((BoltStateMachine)Mockito.verify((Object)this.machine)).close();
    }

    @Test
    public void stateMachineIsClosedOnExit() {
        RunnableBoltWorker worker = new RunnableBoltWorker(this.machine, this.logService);
        worker.enqueue(machine1 -> {
            machine1.run("RETURN 1", null, null);
            worker.enqueue(machine2 -> {
                machine2.run("RETURN 1", null, null);
                worker.enqueue(machine3 -> {
                    worker.halt();
                    worker.enqueue(machine4 -> Assert.fail((String)"Should not be executed"));
                });
            });
        });
        worker.run();
        ((BoltStateMachine)Mockito.verify((Object)this.machine)).close();
    }

    @Test
    public void stateMachineNotClosedOnHalt() {
        RunnableBoltWorker worker = new RunnableBoltWorker(this.machine, this.logService);
        worker.halt();
        ((BoltStateMachine)Mockito.verify((Object)this.machine, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void stateMachineInterrupted() {
        RunnableBoltWorker worker = new RunnableBoltWorker(this.machine, this.logService);
        worker.interrupt();
        ((BoltStateMachine)Mockito.verify((Object)this.machine)).interrupt();
    }

    @Test
    public void stateMachineCloseFailureIsLogged() {
        RunnableBoltWorker worker = new RunnableBoltWorker(this.machine, this.logService);
        RuntimeException closeError = new RuntimeException("Oh!");
        ((BoltStateMachine)Mockito.doThrow((Throwable)closeError).when((Object)this.machine)).close();
        worker.enqueue(s -> worker.halt());
        worker.run();
        this.internalLog.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(RunnableBoltWorker.class).error(Matchers.equalTo((Object)"Unable to close Bolt session 'test-session'"), Matchers.equalTo((Object)closeError))});
    }

    @Test
    public void haltIsRespected() {
        RunnableBoltWorker worker = new RunnableBoltWorker(this.machine, this.logService);
        worker.enqueue(machine1 -> worker.enqueue(machine2 -> worker.enqueue(machine3 -> {
            worker.halt();
            ((BoltStateMachine)Mockito.verify((Object)this.machine)).terminate();
            worker.enqueue(machine4 -> Assert.fail((String)"Should not be executed"));
        })));
        worker.run();
        ((BoltStateMachine)Mockito.verify((Object)this.machine)).close();
    }

    @Test
    public void runDoesNothingAfterHalt() {
        RunnableBoltWorker worker = new RunnableBoltWorker(this.machine, this.logService);
        MutableBoolean jobWasExecuted = new MutableBoolean();
        worker.enqueue(machine1 -> {
            jobWasExecuted.setTrue();
            Assert.fail((String)"Should not be executed");
        });
        worker.halt();
        worker.run();
        Assert.assertFalse((boolean)jobWasExecuted.booleanValue());
        ((BoltStateMachine)Mockito.verify((Object)this.machine)).close();
    }
}

