/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.bookmarking;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.bolt.v1.runtime.bookmarking.Bookmark;

public class BookmarkTest {
    @Test
    public void shouldFormatAndParseSingleBookmarkContainingTransactionId() throws Exception {
        long txId = 1234L;
        Map<String, String> params = Collections.singletonMap("bookmark", new Bookmark(txId).toString());
        Bookmark bookmark = Bookmark.fromParamsOrNull(params);
        Assert.assertEquals((long)txId, (long)bookmark.txId());
    }

    @Test
    public void shouldFormatAndParseMultipleBookmarksContainingTransactionId() throws Exception {
        long txId1 = 1234L;
        long txId2 = 12345L;
        Map<String, List<String>> params = Collections.singletonMap("bookmarks", Arrays.asList(new Bookmark(txId1).toString(), new Bookmark(txId2).toString()));
        Bookmark bookmark = Bookmark.fromParamsOrNull(params);
        Assert.assertEquals((long)txId2, (long)bookmark.txId());
    }

    @Test
    public void shouldParseAndFormatSingleBookmarkContainingTransactionId() throws Exception {
        String expected = "neo4j:bookmark:v1:tx1234";
        Map<String, String> params = Collections.singletonMap("bookmark", expected);
        String actual = new Bookmark(Bookmark.fromParamsOrNull(params).txId()).toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldParseAndFormatMultipleBookmarkContainingTransactionId() throws Exception {
        String txId1 = "neo4j:bookmark:v1:tx1234";
        String txId2 = "neo4j:bookmark:v1:tx12345";
        Map<String, List<String>> params = Collections.singletonMap("bookmarks", Arrays.asList(txId1, txId2));
        String actual = new Bookmark(Bookmark.fromParamsOrNull(params).txId()).toString();
        Assert.assertEquals((Object)txId2, (Object)actual);
    }

    @Test
    public void shouldFailWhenParsingBadlyFormattedSingleBookmark() throws Exception {
        String bookmarkString = "neo4q:markbook:v9:xt998";
        try {
            Bookmark.fromParamsOrNull(Collections.singletonMap("bookmark", bookmarkString));
            Assert.fail((String)"should have thrown exception");
        }
        catch (Bookmark.BookmarkFormatException bookmarkFormatException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailWhenParsingBadlyFormattedMultipleBookmarks() throws Exception {
        String bookmarkString = "neo4j:bookmark:v1:tx998";
        String wrongBookmarkString = "neo4q:markbook:v9:xt998";
        try {
            Bookmark.fromParamsOrNull(Collections.singletonMap("bookmarks", Arrays.asList(bookmarkString, wrongBookmarkString)));
            Assert.fail((String)"should have thrown exception");
        }
        catch (Bookmark.BookmarkFormatException bookmarkFormatException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailWhenNoNumberFollowsThePrefixInSingleBookmark() throws Exception {
        String bookmarkString = "neo4j:bookmark:v1:tx";
        try {
            Bookmark.fromParamsOrNull(Collections.singletonMap("bookmark", bookmarkString));
            Assert.fail((String)"should have thrown exception");
        }
        catch (Bookmark.BookmarkFormatException bookmarkFormatException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailWhenNoNumberFollowsThePrefixInMultipleBookmarks() throws Exception {
        String bookmarkString = "neo4j:bookmark:v1:tx10";
        String wrongBookmarkString = "neo4j:bookmark:v1:tx";
        try {
            Bookmark.fromParamsOrNull(Collections.singletonMap("bookmarks", Arrays.asList(bookmarkString, wrongBookmarkString)));
            Assert.fail((String)"should have thrown exception");
        }
        catch (Bookmark.BookmarkFormatException bookmarkFormatException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailWhenSingleBookmarkHasExtraneousTrailingCharacters() throws Exception {
        String bookmarkString = "neo4j:bookmark:v1:tx1234supercalifragilisticexpialidocious";
        try {
            Bookmark.fromParamsOrNull(Collections.singletonMap("bookmark", bookmarkString));
            Assert.fail((String)"should have thrown exception");
        }
        catch (Bookmark.BookmarkFormatException bookmarkFormatException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailWhenMultipleBookmarksHaveExtraneousTrailingCharacters() throws Exception {
        String bookmarkString = "neo4j:bookmark:v1:tx1234";
        String wrongBookmarkString = "neo4j:bookmark:v1:tx1234supercalifragilisticexpialidocious";
        try {
            Bookmark.fromParamsOrNull(Collections.singletonMap("bookmarks", Arrays.asList(bookmarkString, wrongBookmarkString)));
            Assert.fail((String)"should have thrown exception");
        }
        catch (Bookmark.BookmarkFormatException bookmarkFormatException) {
            // empty catch block
        }
    }

    @Test
    public void shouldUseMultipleBookmarksWhenGivenBothSingleAndMultiple() throws Exception {
        Map<String, Object> params = BookmarkTest.params("neo4j:bookmark:v1:tx42", Arrays.asList("neo4j:bookmark:v1:tx10", "neo4j:bookmark:v1:tx99", "neo4j:bookmark:v1:tx3"));
        Bookmark bookmark = Bookmark.fromParamsOrNull(params);
        Assert.assertEquals((long)99L, (long)bookmark.txId());
    }

    @Test
    public void shouldUseMultipleBookmarksWhenGivenOnlyMultiple() throws Exception {
        Map<String, Object> params = BookmarkTest.params(null, Arrays.asList("neo4j:bookmark:v1:tx85", "neo4j:bookmark:v1:tx47", "neo4j:bookmark:v1:tx15", "neo4j:bookmark:v1:tx6"));
        Bookmark bookmark = Bookmark.fromParamsOrNull(params);
        Assert.assertEquals((long)85L, (long)bookmark.txId());
    }

    @Test
    public void shouldUseSingleBookmarkWhenGivenOnlySingle() throws Exception {
        Map<String, Object> params = BookmarkTest.params("neo4j:bookmark:v1:tx82", null);
        Bookmark bookmark = Bookmark.fromParamsOrNull(params);
        Assert.assertEquals((long)82L, (long)bookmark.txId());
    }

    @Test
    public void shouldUseSingleBookmarkWhenGivenBothSingleAndNullAsMultiple() throws Exception {
        Map<String, Object> params = BookmarkTest.params("neo4j:bookmark:v1:tx58", null);
        Bookmark bookmark = Bookmark.fromParamsOrNull(params);
        Assert.assertEquals((long)58L, (long)bookmark.txId());
    }

    @Test
    public void shouldUseSingleBookmarkWhenGivenBothSingleAndEmptyListAsMultiple() throws Exception {
        Map<String, Object> params = BookmarkTest.params("neo4j:bookmark:v1:tx67", Collections.emptyList());
        Bookmark bookmark = Bookmark.fromParamsOrNull(params);
        Assert.assertEquals((long)67L, (long)bookmark.txId());
    }

    @Test
    public void shouldThrowWhenMultipleBookmarksIsNotAList() throws Exception {
        Map<String, Object> params = BookmarkTest.params("neo4j:bookmark:v1:tx67", new String[]{"neo4j:bookmark:v1:tx68"});
        try {
            Bookmark.fromParamsOrNull(params);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(Bookmark.BookmarkFormatException.class));
        }
    }

    @Test
    public void shouldThrowWhenMultipleBookmarksIsNotAListOfStrings() throws Exception {
        Map<String, Object> params = BookmarkTest.params("neo4j:bookmark:v1:tx67", Arrays.asList({"neo4j:bookmark:v1:tx50"}, {"neo4j:bookmark:v1:tx89"}));
        try {
            Bookmark.fromParamsOrNull(params);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(Bookmark.BookmarkFormatException.class));
        }
    }

    @Test
    public void shouldThrowWhenOneOfMultipleBookmarksIsMalformed() {
        Map<String, Object> params = BookmarkTest.params("neo4j:bookmark:v1:tx67", Arrays.asList("neo4j:bookmark:v1:tx99", "neo4j:bookmark:v1:tx12", "neo4j:bookmark:www:tx99"));
        try {
            Bookmark.fromParamsOrNull(params);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(Bookmark.BookmarkFormatException.class));
        }
    }

    @Test
    public void shouldThrowWhenSingleBookmarkIsMalformed() {
        Map<String, Object> params = BookmarkTest.params("neo4j:strange-bookmark:v1:tx6", null);
        try {
            Bookmark.fromParamsOrNull(params);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(Bookmark.BookmarkFormatException.class));
        }
    }

    @Test
    public void shouldReturnNullWhenNoBookmarks() throws Exception {
        Assert.assertNull((Object)Bookmark.fromParamsOrNull(Collections.emptyMap()));
    }

    @Test
    public void shouldReturnNullWhenGivenEmptyListForMultipleBookmarks() throws Exception {
        Map<String, Object> params = BookmarkTest.params(null, Collections.emptyList());
        Assert.assertNull((Object)Bookmark.fromParamsOrNull(params));
    }

    @Test
    public void shouldSkipNullsInMultipleBookmarks() throws Exception {
        Map<String, Object> params = BookmarkTest.params(null, Arrays.asList("neo4j:bookmark:v1:tx3", "neo4j:bookmark:v1:tx5", null, "neo4j:bookmark:v1:tx17"));
        Bookmark bookmark = Bookmark.fromParamsOrNull(params);
        Assert.assertEquals((long)17L, (long)bookmark.txId());
    }

    private static Map<String, Object> params(String bookmark, Object bookmarks) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (bookmark != null) {
            result.put("bookmark", bookmark);
        }
        result.put("bookmarks", bookmarks);
        return result;
    }
}

