/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;
import org.neo4j.bolt.v1.runtime.TransactionStateMachineSPI;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.time.FakeClock;

public class TransactionStateMachineTest {
    private TransactionStateMachineSPI stateMachineSPI;
    private TransactionStateMachine.MutableTransactionState mutableState;
    private TransactionStateMachine stateMachine;

    @Before
    public void createMocks() {
        this.stateMachineSPI = (TransactionStateMachineSPI)Mockito.mock(TransactionStateMachineSPI.class);
        this.mutableState = (TransactionStateMachine.MutableTransactionState)Mockito.mock(TransactionStateMachine.MutableTransactionState.class);
        this.stateMachine = new TransactionStateMachine((TransactionStateMachine.SPI)this.stateMachineSPI, AuthenticationResult.AUTH_DISABLED, (Clock)new FakeClock());
    }

    @Test
    public void shouldTransitionToExplicitTransactionOnBegin() throws Exception {
        Assert.assertEquals((Object)TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "begin", Collections.emptyMap()), (Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION);
        Assert.assertEquals((Object)TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "BEGIN", Collections.emptyMap()), (Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION);
        Assert.assertEquals((Object)TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "   begin   ", Collections.emptyMap()), (Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION);
        Assert.assertEquals((Object)TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "   BeGiN ;   ", Collections.emptyMap()), (Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION);
    }

    @Test
    public void shouldTransitionToAutoCommitOnCommit() throws Exception {
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "commit", Collections.emptyMap()), (Object)TransactionStateMachine.State.AUTO_COMMIT);
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "COMMIT", Collections.emptyMap()), (Object)TransactionStateMachine.State.AUTO_COMMIT);
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "   commit   ", Collections.emptyMap()), (Object)TransactionStateMachine.State.AUTO_COMMIT);
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "   CoMmIt ;   ", Collections.emptyMap()), (Object)TransactionStateMachine.State.AUTO_COMMIT);
    }

    @Test
    public void shouldTransitionToAutoCommitOnRollback() throws Exception {
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "rollback", Collections.emptyMap()), (Object)TransactionStateMachine.State.AUTO_COMMIT);
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "ROLLBACK", Collections.emptyMap()), (Object)TransactionStateMachine.State.AUTO_COMMIT);
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "   rollback   ", Collections.emptyMap()), (Object)TransactionStateMachine.State.AUTO_COMMIT);
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "   RoLlBaCk ;   ", Collections.emptyMap()), (Object)TransactionStateMachine.State.AUTO_COMMIT);
    }

    @Test
    public void shouldThrowOnBeginInExplicitTransaction() throws Exception {
        try {
            TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "begin", Collections.emptyMap());
        }
        catch (QueryExecutionKernelException ex) {
            Assert.assertEquals((Object)"Nested transactions are not supported.", (Object)ex.getMessage());
        }
        try {
            TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, " BEGIN ", Collections.emptyMap());
        }
        catch (QueryExecutionKernelException ex) {
            Assert.assertEquals((Object)"Nested transactions are not supported.", (Object)ex.getMessage());
        }
    }

    @Test
    public void shouldThrowOnRollbackInAutoCommit() throws Exception {
        try {
            TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "rollback", Collections.emptyMap());
        }
        catch (QueryExecutionKernelException ex) {
            Assert.assertEquals((Object)"No current transaction to rollback.", (Object)ex.getMessage());
        }
        try {
            TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, " ROLLBACK ", Collections.emptyMap());
        }
        catch (QueryExecutionKernelException ex) {
            Assert.assertEquals((Object)"No current transaction to rollback.", (Object)ex.getMessage());
        }
    }

    @Test
    public void shouldThrowOnCommitInAutoCommit() throws Exception {
        try {
            TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "commit", Collections.emptyMap());
        }
        catch (QueryExecutionKernelException ex) {
            Assert.assertEquals((Object)"No current transaction to commit.", (Object)ex.getMessage());
        }
        try {
            TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, " COMMIT ", Collections.emptyMap());
        }
        catch (QueryExecutionKernelException ex) {
            Assert.assertEquals((Object)"No current transaction to commit.", (Object)ex.getMessage());
        }
    }

    @Test
    public void shouldNotWaitWhenNoBookmarkSupplied() throws Exception {
        this.stateMachine.run("BEGIN", Collections.emptyMap());
        ((TransactionStateMachineSPI)Mockito.verify((Object)this.stateMachineSPI, (VerificationMode)Mockito.never())).awaitUpToDate(Matchers.anyLong());
    }

    @Test
    public void shouldAwaitSingleBookmark() throws Exception {
        this.stateMachine.run("BEGIN", MapUtil.map((Object[])new Object[]{"bookmark", "neo4j:bookmark:v1:tx15"}));
        ((TransactionStateMachineSPI)Mockito.verify((Object)this.stateMachineSPI)).awaitUpToDate(15L);
    }

    @Test
    public void shouldAwaitMultipleBookmarks() throws Exception {
        Map params = MapUtil.map((Object[])new Object[]{"bookmarks", Arrays.asList("neo4j:bookmark:v1:tx15", "neo4j:bookmark:v1:tx5", "neo4j:bookmark:v1:tx92", "neo4j:bookmark:v1:tx9")});
        this.stateMachine.run("BEGIN", params);
        ((TransactionStateMachineSPI)Mockito.verify((Object)this.stateMachineSPI)).awaitUpToDate(92L);
    }

    @Test
    public void shouldAwaitMultipleBookmarksWhenBothSingleAndMultipleSupplied() throws Exception {
        Map params = MapUtil.map((Object[])new Object[]{"bookmark", "neo4j:bookmark:v1:tx42", "bookmarks", Arrays.asList("neo4j:bookmark:v1:tx47", "neo4j:bookmark:v1:tx67", "neo4j:bookmark:v1:tx45")});
        this.stateMachine.run("BEGIN", params);
        ((TransactionStateMachineSPI)Mockito.verify((Object)this.stateMachineSPI)).awaitUpToDate(67L);
    }
}

