/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Test;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.v1.messaging.BoltMessageRouter;
import org.neo4j.bolt.v1.messaging.BoltResponseMessage;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageHandler;
import org.neo4j.bolt.v1.messaging.message.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.runtime.BoltConnectionDescriptor;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;
import org.neo4j.bolt.v1.runtime.concurrent.ThreadedWorkerFactory;
import org.neo4j.bolt.v1.runtime.spi.Record;
import org.neo4j.concurrent.Runnables;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.scheduler.JobScheduler;

public class ResetFuzzTest {
    private static final BoltConnectionDescriptor CONNECTION_DESCRIPTOR = new BoltConnectionDescriptor((SocketAddress)new InetSocketAddress("<testClient>", 56789), (SocketAddress)new InetSocketAddress("<testServer>", 7468));
    private final int seed = new Random().nextInt();
    private final Random rand = new Random(this.seed);
    private final LifeSupport life = new LifeSupport();
    private final AtomicLong liveTransactions = new AtomicLong();
    private final Neo4jJobScheduler scheduler = (Neo4jJobScheduler)this.life.add((Lifecycle)new Neo4jJobScheduler());
    private final Clock clock = Clock.systemUTC();
    private final BoltStateMachine machine = new BoltStateMachine((BoltStateMachine.SPI)new FuzzStubSPI(), null, this.clock);
    private final ThreadedWorkerFactory sessions = new ThreadedWorkerFactory((enc, closer, clock) -> this.machine, (JobScheduler)this.scheduler, (LogService)NullLogService.getInstance(), this.clock);
    private final List<List<RequestMessage>> sequences = Arrays.asList(Arrays.asList(RunMessage.run("test", MapUtil.map((Object[])new Object[0])), DiscardAllMessage.discardAll()), Arrays.asList(RunMessage.run("test", MapUtil.map((Object[])new Object[0])), PullAllMessage.pullAll()), Collections.singletonList(RunMessage.run("test", MapUtil.map((Object[])new Object[0]))));
    private final List<RequestMessage> sent = new LinkedList<RequestMessage>();

    @Test
    public void shouldAlwaysReturnToReadyAfterReset() throws Throwable {
        this.life.start();
        BoltWorker boltWorker = this.sessions.newWorker(CONNECTION_DESCRIPTOR);
        boltWorker.enqueue(session -> session.init("ResetFuzzTest/0.0", MapUtil.map((Object[])new Object[0]), (BoltResponseHandler)NullResponseHandler.nullResponseHandler()));
        BoltMessageRouter router = new BoltMessageRouter((Log)NullLog.getInstance(), boltWorker, (BoltResponseMessageHandler)new BoltResponseMessageHandler<IOException>(){

            public void onRecord(Record item) throws IOException {
            }

            public void onIgnored() throws IOException {
            }

            public void onFailure(Status status, String message) throws IOException {
            }

            public void onSuccess(Map metadata) throws IOException {
            }
        }, Runnables.EMPTY_RUNNABLE);
        long deadline = System.currentTimeMillis() + 2000L;
        while (System.currentTimeMillis() < deadline) {
            this.dispatchRandomSequenceOfMessages(router);
            this.assertWorkerWorks(boltWorker);
        }
    }

    private void assertWorkerWorks(BoltWorker worker) throws InterruptedException {
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        worker.enqueue(machine -> machine.reset((BoltResponseHandler)recorder));
        try {
            RecordedBoltResponse response = recorder.nextResponse();
            MatcherAssert.assertThat((Object)BoltResponseMessage.SUCCESS, (Matcher)CoreMatchers.equalTo((Object)response.message()));
            MatcherAssert.assertThat((Object)this.machine.state(), (Matcher)CoreMatchers.equalTo((Object)BoltStateMachine.State.READY));
            MatcherAssert.assertThat((Object)this.liveTransactions.get(), (Matcher)CoreMatchers.equalTo((Object)0L));
        }
        catch (AssertionError e) {
            throw new AssertionError(String.format("Expected session to return to good state after RESET, but assertion failed: %s.%nSeed: %s%nMessages sent:%n%s", ((Throwable)((Object)e)).getMessage(), this.seed, Iterables.toString(this.sent, (String)"\n")), (Throwable)((Object)e));
        }
    }

    private void dispatchRandomSequenceOfMessages(BoltMessageRouter messageHandler) {
        List<RequestMessage> sequence = this.sequences.get(this.rand.nextInt(this.sequences.size()));
        for (RequestMessage message : sequence) {
            this.sent.add(message);
            message.dispatch(messageHandler);
        }
    }

    @After
    public void cleanup() {
        this.life.shutdown();
    }

    private class FuzzStubSPI
    implements BoltStateMachine.SPI {
        private FuzzStubSPI() {
        }

        public BoltConnectionDescriptor connectionDescriptor() {
            return CONNECTION_DESCRIPTOR;
        }

        public void register(BoltStateMachine machine, String owner) {
        }

        public TransactionStateMachine.SPI transactionSpi() {
            return null;
        }

        public void onTerminate(BoltStateMachine machine) {
        }

        public void reportError(Neo4jError err) {
        }

        public AuthenticationResult authenticate(Map<String, Object> authToken) throws AuthenticationException {
            return AuthenticationResult.AUTH_DISABLED;
        }

        public void udcRegisterClient(String clientName) {
        }

        public String version() {
            return "<test-version>";
        }
    }
}

