/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltConnectionDescriptor;
import org.neo4j.bolt.v1.runtime.BoltConnectionFatality;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.Job;
import org.neo4j.bolt.v1.runtime.MonitoredWorkerFactory;
import org.neo4j.bolt.v1.runtime.WorkerFactory;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class MonitoredBoltWorkerFactoryTest {
    private static final BoltConnectionDescriptor CONNECTION_DESCRIPTOR = new BoltConnectionDescriptor((SocketAddress)new InetSocketAddress("<testClient>", 56789), (SocketAddress)new InetSocketAddress("<testServer>", 7468));

    @Test
    public void shouldSignalReceivedStartAndComplete() throws Throwable {
        final FakeClock clock = Clocks.fakeClock();
        WorkerFactory delegate = (WorkerFactory)Mockito.mock(WorkerFactory.class);
        final BoltStateMachine machine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        Mockito.when((Object)delegate.newWorker((BoltConnectionDescriptor)Matchers.anyObject(), (Runnable)Matchers.anyObject())).thenReturn((Object)new BoltWorker(){

            public void enqueue(Job job) {
                clock.forward(1337L, TimeUnit.MILLISECONDS);
                try {
                    job.perform(machine);
                }
                catch (BoltConnectionFatality connectionFatality) {
                    throw new RuntimeException(connectionFatality);
                }
            }

            public void interrupt() {
                throw new RuntimeException();
            }

            public void halt() {
                throw new RuntimeException();
            }
        });
        Monitors monitors = new Monitors();
        CountingSessionMonitor monitor = new CountingSessionMonitor();
        monitors.addMonitorListener((Object)monitor, new String[0]);
        MonitoredWorkerFactory workerFactory = new MonitoredWorkerFactory(monitors, delegate, (Clock)clock);
        BoltWorker worker = workerFactory.newWorker(CONNECTION_DESCRIPTOR);
        worker.enqueue(stateMachine -> {
            stateMachine.run("hello", null, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
            clock.forward(1338L, TimeUnit.MILLISECONDS);
        });
        Assert.assertEquals((long)1L, (long)monitor.messagesReceived);
        Assert.assertEquals((long)1337L, (long)monitor.queueTime);
        Assert.assertEquals((long)1338L, (long)monitor.processingTime);
    }

    @Test
    public void shouldReportStartedSessions() {
        int workersCount = 42;
        Monitors monitors = new Monitors();
        CountingSessionMonitor monitor = new CountingSessionMonitor();
        monitors.addMonitorListener((Object)monitor, new String[0]);
        WorkerFactory mockWorkers = (WorkerFactory)Mockito.mock(WorkerFactory.class);
        Mockito.when((Object)mockWorkers.newWorker((BoltConnectionDescriptor)Matchers.anyObject(), (Runnable)Matchers.any())).thenReturn(Mockito.mock(BoltWorker.class));
        MonitoredWorkerFactory workerFactory = new MonitoredWorkerFactory(monitors, mockWorkers, Clocks.systemClock());
        for (int i = 0; i < workersCount; ++i) {
            workerFactory.newWorker(CONNECTION_DESCRIPTOR);
        }
        Assert.assertEquals((long)workersCount, (long)monitor.sessionsStarted);
    }

    @Test
    public void shouldNotWrapWithMonitoredSessionIfNobodyIsListening() throws Throwable {
        WorkerFactory workerFactory = (WorkerFactory)Mockito.mock(WorkerFactory.class);
        BoltWorker innerSession = (BoltWorker)Mockito.mock(BoltWorker.class);
        Mockito.when((Object)workerFactory.newWorker((BoltConnectionDescriptor)Matchers.anyObject(), (Runnable)Matchers.anyObject())).thenReturn((Object)innerSession);
        Monitors monitors = new Monitors();
        MonitoredWorkerFactory monitoredWorkerFactory = new MonitoredWorkerFactory(monitors, workerFactory, (Clock)Clocks.fakeClock());
        BoltWorker worker = monitoredWorkerFactory.newWorker(CONNECTION_DESCRIPTOR);
        Assert.assertEquals((Object)innerSession, (Object)worker);
        monitors.addMonitorListener((Object)new CountingSessionMonitor(), new String[0]);
        MatcherAssert.assertThat((Object)monitoredWorkerFactory.newWorker(CONNECTION_DESCRIPTOR), (Matcher)CoreMatchers.instanceOf(MonitoredWorkerFactory.MonitoredBoltWorker.class));
    }

    private static class CountingSessionMonitor
    implements MonitoredWorkerFactory.SessionMonitor {
        long sessionsStarted;
        long messagesReceived;
        long queueTime;
        long processingTime;

        private CountingSessionMonitor() {
        }

        public void sessionStarted() {
            ++this.sessionsStarted;
        }

        public void messageReceived() {
            ++this.messagesReceived;
        }

        public void processingStarted(long queueTime) {
            this.queueTime += queueTime;
        }

        public void processingDone(long processingTime) {
            this.processingTime += processingTime;
        }
    }
}

