/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.MatcherAssert;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltConnectionFatality;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.BoltStateMachineSPI;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;

public class MachineRoom {
    static final Map<String, Object> EMPTY_PARAMS = Collections.emptyMap();
    static final String USER_AGENT = "BoltStateMachineTest/0.0";

    private MachineRoom() {
    }

    public static BoltStateMachine newMachine() {
        return new BoltStateMachine((BoltStateMachine.SPI)Mockito.mock(BoltStateMachineSPI.class, (Answer)Mockito.RETURNS_MOCKS), null, Clock.systemUTC());
    }

    public static BoltStateMachine newMachine(BoltStateMachine.State state) throws AuthenticationException, BoltConnectionFatality {
        BoltStateMachine machine = MachineRoom.newMachine();
        MachineRoom.init(machine);
        machine.state = state;
        return machine;
    }

    public static BoltStateMachine newMachineWithTransaction(BoltStateMachine.State state) throws AuthenticationException, BoltConnectionFatality {
        BoltStateMachine machine = MachineRoom.newMachine();
        MachineRoom.init(machine);
        MachineRoom.runBegin(machine);
        machine.state = state;
        return machine;
    }

    public static BoltStateMachine newMachineWithTransactionSPI(TransactionStateMachine.SPI transactionSPI) throws AuthenticationException, BoltConnectionFatality {
        BoltStateMachine.SPI spi = (BoltStateMachine.SPI)Mockito.mock(BoltStateMachine.SPI.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)spi.transactionSpi()).thenReturn((Object)transactionSPI);
        BoltStateMachine machine = new BoltStateMachine(spi, null, Clock.systemUTC());
        MachineRoom.init(machine);
        return machine;
    }

    private static void init(BoltStateMachine machine) throws AuthenticationException, BoltConnectionFatality {
        Mockito.when((Object)machine.spi.authenticate((Map)Matchers.anyObject())).thenReturn(Mockito.mock(AuthenticationResult.class));
        machine.init(USER_AGENT, Collections.emptyMap(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
    }

    private static void runBegin(BoltStateMachine machine) throws AuthenticationException, BoltConnectionFatality {
        machine.run("BEGIN", EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.hasTransaction());
    }
}

