/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.v1.runtime.CypherAdapterStream;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.bolt.v1.runtime.spi.Record;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.impl.notification.NotificationCode;
import org.neo4j.graphdb.impl.notification.NotificationDetail;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.query.TransactionalContext;

public class CypherAdapterStreamTest {
    @Test
    public void shouldIncludeBasicMetadata() throws Throwable {
        QueryStatistics queryStatistics = (QueryStatistics)Mockito.mock(QueryStatistics.class);
        Mockito.when((Object)queryStatistics.containsUpdates()).thenReturn((Object)true);
        Mockito.when((Object)queryStatistics.getNodesCreated()).thenReturn((Object)1);
        Mockito.when((Object)queryStatistics.getNodesDeleted()).thenReturn((Object)2);
        Mockito.when((Object)queryStatistics.getRelationshipsCreated()).thenReturn((Object)3);
        Mockito.when((Object)queryStatistics.getRelationshipsDeleted()).thenReturn((Object)4);
        Mockito.when((Object)queryStatistics.getPropertiesSet()).thenReturn((Object)5);
        Mockito.when((Object)queryStatistics.getIndexesAdded()).thenReturn((Object)6);
        Mockito.when((Object)queryStatistics.getIndexesRemoved()).thenReturn((Object)7);
        Mockito.when((Object)queryStatistics.getConstraintsAdded()).thenReturn((Object)8);
        Mockito.when((Object)queryStatistics.getConstraintsRemoved()).thenReturn((Object)9);
        Mockito.when((Object)queryStatistics.getLabelsAdded()).thenReturn((Object)10);
        Mockito.when((Object)queryStatistics.getLabelsRemoved()).thenReturn((Object)11);
        Result result = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)result.getQueryExecutionType()).thenReturn((Object)QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE));
        Mockito.when((Object)result.getQueryStatistics()).thenReturn((Object)queryStatistics);
        Mockito.when((Object)result.getNotifications()).thenReturn(Collections.emptyList());
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).thenReturn((Object)0L, (Object[])new Long[]{1337L});
        TransactionalContext tc = (TransactionalContext)Mockito.mock(TransactionalContext.class);
        CypherAdapterStream stream = new CypherAdapterStream(result, clock);
        Map<String, Object> meta = this.metadataOf(stream);
        MatcherAssert.assertThat((Object)meta.get("type").toString(), (Matcher)CoreMatchers.equalTo((Object)"rw"));
        MatcherAssert.assertThat((Object)meta.get("stats"), (Matcher)CoreMatchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"nodes-created", 1, "nodes-deleted", 2, "relationships-created", 3, "relationships-deleted", 4, "properties-set", 5, "indexes-added", 6, "indexes-removed", 7, "constraints-added", 8, "constraints-removed", 9, "labels-added", 10, "labels-removed", 11})));
        MatcherAssert.assertThat((Object)meta.get("result_consumed_after"), (Matcher)CoreMatchers.equalTo((Object)1337L));
    }

    @Test
    public void shouldIncludePlanIfPresent() throws Throwable {
        QueryStatistics queryStatistics = (QueryStatistics)Mockito.mock(QueryStatistics.class);
        Mockito.when((Object)queryStatistics.containsUpdates()).thenReturn((Object)false);
        Result result = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)result.getQueryExecutionType()).thenReturn((Object)QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY));
        Mockito.when((Object)result.getQueryStatistics()).thenReturn((Object)queryStatistics);
        Mockito.when((Object)result.getNotifications()).thenReturn(Collections.emptyList());
        Mockito.when((Object)result.getExecutionPlanDescription()).thenReturn((Object)CypherAdapterStreamTest.plan("Join", (Map<String, Object>)MapUtil.map((Object[])new Object[]{"arg1", 1}), Collections.singletonList("id1"), CypherAdapterStreamTest.plan("Scan", (Map<String, Object>)MapUtil.map((Object[])new Object[]{"arg2", 1}), Collections.singletonList("id2"), new ExecutionPlanDescription[0])));
        TransactionalContext tc = (TransactionalContext)Mockito.mock(TransactionalContext.class);
        CypherAdapterStream stream = new CypherAdapterStream(result, Clock.systemUTC());
        Map<String, Object> meta = this.metadataOf(stream);
        Map expectedChild = MapUtil.map((Object[])new Object[]{"args", MapUtil.map((Object[])new Object[]{"arg2", 1}), "identifiers", Iterators.asSet((Object[])new String[]{"id2"}), "operatorType", "Scan", "children", Collections.EMPTY_LIST});
        Map expectedPlan = MapUtil.map((Object[])new Object[]{"args", MapUtil.map((Object[])new Object[]{"arg1", 1}), "identifiers", Iterators.asSet((Object[])new String[]{"id1"}), "operatorType", "Join", "children", Arrays.asList(expectedChild)});
        MatcherAssert.assertThat((Object)meta.get("plan"), (Matcher)CoreMatchers.equalTo((Object)expectedPlan));
    }

    @Test
    public void shouldIncludeProfileIfPresent() throws Throwable {
        QueryStatistics queryStatistics = (QueryStatistics)Mockito.mock(QueryStatistics.class);
        Mockito.when((Object)queryStatistics.containsUpdates()).thenReturn((Object)false);
        Result result = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)result.getQueryExecutionType()).thenReturn((Object)QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY));
        Mockito.when((Object)result.getQueryStatistics()).thenReturn((Object)queryStatistics);
        Mockito.when((Object)result.getNotifications()).thenReturn(Collections.emptyList());
        Mockito.when((Object)result.getExecutionPlanDescription()).thenReturn((Object)CypherAdapterStreamTest.plan("Join", (Map<String, Object>)MapUtil.map((Object[])new Object[]{"arg1", 1}), 2L, 4L, 3L, 1L, Collections.singletonList("id1"), CypherAdapterStreamTest.plan("Scan", (Map<String, Object>)MapUtil.map((Object[])new Object[]{"arg2", 1}), 2L, 4L, 7L, 1L, Collections.singletonList("id2"), new ExecutionPlanDescription[0])));
        TransactionalContext tc = (TransactionalContext)Mockito.mock(TransactionalContext.class);
        CypherAdapterStream stream = new CypherAdapterStream(result, Clock.systemUTC());
        Map<String, Object> meta = this.metadataOf(stream);
        Map expectedChild = MapUtil.map((Object[])new Object[]{"args", MapUtil.map((Object[])new Object[]{"arg2", 1}), "identifiers", Iterators.asSet((Object[])new String[]{"id2"}), "operatorType", "Scan", "children", Collections.EMPTY_LIST, "rows", 1L, "dbHits", 2L, "pageCacheHits", 4L, "pageCacheMisses", 7L, "pageCacheHitRatio", 0.36363636363636365});
        Map expectedProfile = MapUtil.map((Object[])new Object[]{"args", MapUtil.map((Object[])new Object[]{"arg1", 1}), "identifiers", Iterators.asSet((Object[])new String[]{"id1"}), "operatorType", "Join", "children", Arrays.asList(expectedChild), "rows", 1L, "dbHits", 2L, "pageCacheHits", 4L, "pageCacheMisses", 3L, "pageCacheHitRatio", 0.5714285714285714});
        CypherAdapterStreamTest.assertMapEqualsWithDelta((Map)meta.get("profile"), expectedProfile, 1.0E-4);
    }

    @Test
    public void shouldIncludeNotificationsIfPresent() throws Throwable {
        Result result = (Result)Mockito.mock(Result.class);
        QueryStatistics queryStatistics = (QueryStatistics)Mockito.mock(QueryStatistics.class);
        Mockito.when((Object)queryStatistics.containsUpdates()).thenReturn((Object)false);
        Mockito.when((Object)result.getQueryStatistics()).thenReturn((Object)queryStatistics);
        Mockito.when((Object)result.getQueryExecutionType()).thenReturn((Object)QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE));
        Mockito.when((Object)result.getNotifications()).thenReturn(Arrays.asList(NotificationCode.INDEX_HINT_UNFULFILLABLE.notification(InputPosition.empty, new NotificationDetail[0]), NotificationCode.PLANNER_UNSUPPORTED.notification(new InputPosition(4, 5, 6), new NotificationDetail[0])));
        TransactionalContext tc = (TransactionalContext)Mockito.mock(TransactionalContext.class);
        CypherAdapterStream stream = new CypherAdapterStream(result, Clock.systemUTC());
        Map<String, Object> meta = this.metadataOf(stream);
        Map msg1 = MapUtil.map((Object[])new Object[]{"severity", "WARNING", "code", "Neo.ClientError.Schema.IndexNotFound", "title", "The request (directly or indirectly) referred to an index that does not exist.", "description", "The hinted index does not exist, please check the schema"});
        Map msg2 = MapUtil.map((Object[])new Object[]{"severity", "WARNING", "code", "Neo.ClientNotification.Statement.PlannerUnsupportedWarning", "title", "This query is not supported by the COST planner.", "description", "Using COST planner is unsupported for this query, please use RULE planner instead", "position", MapUtil.map((Object[])new Object[]{"offset", 4, "column", 6, "line", 5})});
        MatcherAssert.assertThat((Object)meta.get("notifications"), (Matcher)CoreMatchers.equalTo(Arrays.asList(msg1, msg2)));
    }

    private Map<String, Object> metadataOf(CypherAdapterStream stream) throws Exception {
        final HashMap<String, Object> meta = new HashMap<String, Object>();
        stream.accept(new BoltResult.Visitor(){

            public void visit(Record record) throws Exception {
            }

            public void addMetadata(String key, Object value) {
                meta.put(key, value);
            }
        });
        return meta;
    }

    private static void assertMapEqualsWithDelta(Map<String, Object> a, Map<String, Object> b, double delta) {
        MatcherAssert.assertThat((String)"Map should have same size", (Object)a.size(), (Matcher)CoreMatchers.equalTo((Object)b.size()));
        for (Map.Entry<String, Object> entry : a.entrySet()) {
            String key = entry.getKey();
            MatcherAssert.assertThat((String)"Missing key", (b.get(key) != null ? 1 : 0) != 0);
            Object aValue = entry.getValue();
            Object bValue = b.get(key);
            if (aValue instanceof Map) {
                MatcherAssert.assertThat((String)"Value mismatch", (boolean)(bValue instanceof Map));
                CypherAdapterStreamTest.assertMapEqualsWithDelta((Map)aValue, (Map)bValue, delta);
                continue;
            }
            if (aValue instanceof Double) {
                MatcherAssert.assertThat((String)"Value mismatch", (Object)((Double)aValue), (Matcher)Matchers.closeTo((double)((Double)bValue), (double)delta));
                continue;
            }
            MatcherAssert.assertThat((String)"Value mismatch", (Object)aValue, (Matcher)CoreMatchers.equalTo((Object)bValue));
        }
    }

    private static ExecutionPlanDescription plan(String name, Map<String, Object> args, final long dbHits, final long pageCacheHits, final long pageCacheMisses, final long rows, List<String> identifiers, ExecutionPlanDescription ... children) {
        return CypherAdapterStreamTest.plan(name, args, identifiers, new ExecutionPlanDescription.ProfilerStatistics(){

            public long getRows() {
                return rows;
            }

            public long getDbHits() {
                return dbHits;
            }

            public long getPageCacheHits() {
                return pageCacheHits;
            }

            public long getPageCacheMisses() {
                return pageCacheMisses;
            }
        }, children);
    }

    private static ExecutionPlanDescription plan(String name, Map<String, Object> args, List<String> identifiers, ExecutionPlanDescription ... children) {
        return CypherAdapterStreamTest.plan(name, args, identifiers, null, children);
    }

    private static ExecutionPlanDescription plan(final String name, final Map<String, Object> args, final List<String> identifiers, final ExecutionPlanDescription.ProfilerStatistics profile, final ExecutionPlanDescription ... children) {
        return new ExecutionPlanDescription(){

            public String getName() {
                return name;
            }

            public List<ExecutionPlanDescription> getChildren() {
                return Arrays.asList(children);
            }

            public Map<String, Object> getArguments() {
                return args;
            }

            public Set<String> getIdentifiers() {
                return new HashSet<String>(identifiers);
            }

            public boolean hasProfilerStatistics() {
                return profile != null;
            }

            public ExecutionPlanDescription.ProfilerStatistics getProfilerStatistics() {
                return profile;
            }
        };
    }
}

