/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Clock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.v1.runtime.BoltConnectionDescriptor;
import org.neo4j.bolt.v1.runtime.BoltFactoryImpl;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.OnDemandJobScheduler;
import org.neo4j.udc.UsageData;

public class BoltFactoryImplTest {
    private static final Clock CLOCK = Clock.systemUTC();
    private static final BoltConnectionDescriptor CONNECTION_DESCRIPTOR = new BoltConnectionDescriptor((SocketAddress)new InetSocketAddress("client", 7474), (SocketAddress)new InetSocketAddress("server", 7475));

    @Test
    public void newMachineThrowsWhenNotStarted() {
        BoltFactoryImpl boltFactory = BoltFactoryImplTest.newBoltFactory();
        try {
            boltFactory.newMachine(CONNECTION_DESCRIPTOR, (Runnable)Mockito.mock(Runnable.class), CLOCK);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void newMachineThrowsWhenStopped() throws Throwable {
        BoltFactoryImpl boltFactory = BoltFactoryImplTest.newBoltFactory();
        boltFactory.start();
        BoltStateMachine stateMachine = boltFactory.newMachine(CONNECTION_DESCRIPTOR, (Runnable)Mockito.mock(Runnable.class), CLOCK);
        Assert.assertNotNull((Object)stateMachine);
        boltFactory.stop();
        try {
            boltFactory.newMachine(CONNECTION_DESCRIPTOR, (Runnable)Mockito.mock(Runnable.class), CLOCK);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void txIdStoreRefreshedAfterRestart() throws Throwable {
        GraphDatabaseAPI db = BoltFactoryImplTest.newDbMock();
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        TransactionIdStore txIdStoreBeforeRestart = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)txIdStoreBeforeRestart.getLastClosedTransactionId()).thenReturn((Object)42L);
        TransactionIdStore txIdStoreAfterRestart = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)txIdStoreAfterRestart.getLastClosedTransactionId()).thenReturn((Object)4242L);
        Mockito.when((Object)dependencyResolver.provideDependency(TransactionIdStore.class)).thenReturn(() -> txIdStoreBeforeRestart).thenReturn(() -> txIdStoreAfterRestart);
        BoltFactoryImpl boltFactory = BoltFactoryImplTest.newBoltFactory(db);
        boltFactory.start();
        BoltStateMachine stateMachine1 = boltFactory.newMachine(CONNECTION_DESCRIPTOR, (Runnable)Mockito.mock(Runnable.class), CLOCK);
        Assert.assertEquals((long)42L, (long)stateMachine1.spi.transactionSpi().newestEncounteredTxId());
        boltFactory.stop();
        boltFactory.start();
        BoltStateMachine stateMachine2 = boltFactory.newMachine(CONNECTION_DESCRIPTOR, (Runnable)Mockito.mock(Runnable.class), CLOCK);
        Assert.assertEquals((long)4242L, (long)stateMachine2.spi.transactionSpi().newestEncounteredTxId());
    }

    private static BoltFactoryImpl newBoltFactory() {
        return BoltFactoryImplTest.newBoltFactory(BoltFactoryImplTest.newDbMock());
    }

    private static BoltFactoryImpl newBoltFactory(GraphDatabaseAPI db) {
        return new BoltFactoryImpl(db, new UsageData((JobScheduler)new OnDemandJobScheduler()), (LogService)NullLogService.getInstance(), new ThreadToStatementContextBridge(), (Authentication)Mockito.mock(Authentication.class), BoltConnectionTracker.NOOP, Config.empty());
    }

    private static GraphDatabaseAPI newDbMock() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class);
        DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)db.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        GraphDatabaseQueryService queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        Mockito.when((Object)queryService.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        Mockito.when((Object)dependencyResolver.resolveDependency(GraphDatabaseQueryService.class)).thenReturn((Object)queryService);
        return db;
    }
}

