/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.packstream;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.bolt.v1.packstream.PackOutput;

public class PackedOutputArray
implements PackOutput {
    ByteArrayOutputStream raw = new ByteArrayOutputStream();
    DataOutputStream data = new DataOutputStream(this.raw);

    public PackOutput flush() throws IOException {
        return this;
    }

    public PackOutput writeByte(byte value) throws IOException {
        this.data.write(value);
        return this;
    }

    public PackOutput writeBytes(ByteBuffer buffer) throws IOException {
        while (buffer.remaining() > 0) {
            this.data.writeByte(buffer.get());
        }
        return this;
    }

    public PackOutput writeBytes(byte[] bytes, int offset, int amountToWrite) throws IOException {
        this.data.write(bytes, offset, amountToWrite);
        return this;
    }

    public PackOutput writeShort(short value) throws IOException {
        this.data.writeShort(value);
        return this;
    }

    public PackOutput writeInt(int value) throws IOException {
        this.data.writeInt(value);
        return this;
    }

    public PackOutput writeLong(long value) throws IOException {
        this.data.writeLong(value);
        return this;
    }

    public PackOutput writeDouble(double value) throws IOException {
        this.data.writeDouble(value);
        return this;
    }

    public byte[] bytes() {
        return this.raw.toByteArray();
    }
}

