/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.packstream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.neo4j.bolt.v1.packstream.PackOutput;

public class BufferedChannelOutput
implements PackOutput {
    private final ByteBuffer buffer;
    private WritableByteChannel channel;

    public BufferedChannelOutput(int bufferSize) {
        this.buffer = ByteBuffer.allocate(bufferSize).order(ByteOrder.BIG_ENDIAN);
    }

    public BufferedChannelOutput(WritableByteChannel channel) {
        this(channel, 1024);
    }

    public BufferedChannelOutput(WritableByteChannel channel, int bufferSize) {
        this(bufferSize);
        this.reset(channel);
    }

    public void reset(WritableByteChannel channel) {
        this.channel = channel;
    }

    public BufferedChannelOutput flush() throws IOException {
        this.buffer.flip();
        do {
            this.channel.write(this.buffer);
        } while (this.buffer.remaining() > 0);
        this.buffer.clear();
        return this;
    }

    public PackOutput writeBytes(ByteBuffer data) throws IOException {
        while (data.remaining() > 0) {
            if (this.buffer.remaining() == 0) {
                this.flush();
            }
            int oldLimit = data.limit();
            data.limit(data.position() + Math.min(this.buffer.remaining(), data.remaining()));
            this.buffer.put(data);
            data.limit(oldLimit);
        }
        return this;
    }

    public PackOutput writeBytes(byte[] data, int offset, int length) throws IOException {
        if (offset + length > data.length) {
            throw new IOException("Asked to write " + length + " bytes, but there is only " + (data.length - offset) + " bytes available in data provided.");
        }
        return this.writeBytes(ByteBuffer.wrap(data, offset, length));
    }

    public PackOutput writeByte(byte value) throws IOException {
        this.ensure(1);
        this.buffer.put(value);
        return this;
    }

    public PackOutput writeShort(short value) throws IOException {
        this.ensure(2);
        this.buffer.putShort(value);
        return this;
    }

    public PackOutput writeInt(int value) throws IOException {
        this.ensure(4);
        this.buffer.putInt(value);
        return this;
    }

    public PackOutput writeLong(long value) throws IOException {
        this.ensure(8);
        this.buffer.putLong(value);
        return this;
    }

    public PackOutput writeDouble(double value) throws IOException {
        this.ensure(8);
        this.buffer.putDouble(value);
        return this;
    }

    private void ensure(int size) throws IOException {
        if (this.buffer.remaining() < size) {
            this.flush();
        }
    }
}

