/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageRecorder;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageWriter;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageReader;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageRecorder;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.RecordingByteChannel;
import org.neo4j.bolt.v1.messaging.message.FailureMessage;
import org.neo4j.bolt.v1.messaging.message.IgnoredMessage;
import org.neo4j.bolt.v1.messaging.message.RecordMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.ResponseMessage;
import org.neo4j.bolt.v1.messaging.message.SuccessMessage;
import org.neo4j.bolt.v1.messaging.util.ArrayByteChannel;
import org.neo4j.bolt.v1.packstream.BufferedChannelInput;
import org.neo4j.bolt.v1.packstream.BufferedChannelOutput;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.runtime.spi.Record;
import org.neo4j.bolt.v1.transport.integration.TestNotification;
import org.neo4j.graphdb.Notification;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.HexPrinter;

public class MessageMatchers {
    private MessageMatchers() {
    }

    public static Matcher<List<ResponseMessage>> equalsMessages(final Matcher<ResponseMessage> ... messageMatchers) {
        return new TypeSafeMatcher<List<ResponseMessage>>(){

            protected boolean matchesSafely(List<ResponseMessage> messages) {
                if (messageMatchers.length != messages.size()) {
                    return false;
                }
                for (int i = 0; i < messageMatchers.length; ++i) {
                    if (messageMatchers[i].matches((Object)messages.get(i))) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendList("MessageList[", ", ", "]", Arrays.asList(messageMatchers));
            }
        };
    }

    public static Matcher<ResponseMessage> hasNotification(final Notification notification) {
        return new TypeSafeMatcher<ResponseMessage>(){

            protected boolean matchesSafely(ResponseMessage t) {
                Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(SuccessMessage.class));
                Map<String, Object> meta = ((SuccessMessage)t).meta();
                Assert.assertThat(meta, (Matcher)Matchers.hasKey((Object)"notifications"));
                Set notifications = ((List)meta.get("notifications")).stream().map(TestNotification::fromMap).collect(Collectors.toSet());
                Assert.assertThat(notifications, (Matcher)Matchers.contains((Object[])new Notification[]{notification}));
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("SUCCESS");
            }
        };
    }

    public static Matcher<ResponseMessage> msgSuccess(final Map<String, Object> metadata) {
        return new TypeSafeMatcher<ResponseMessage>(){

            protected boolean matchesSafely(ResponseMessage t) {
                Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(SuccessMessage.class));
                Assert.assertThat(((SuccessMessage)t).meta(), (Matcher)CoreMatchers.equalTo((Object)metadata));
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("SUCCESS");
            }
        };
    }

    public static Matcher<ResponseMessage> msgSuccess(final Matcher<Map<? extends String, ?>> matcher) {
        return new TypeSafeMatcher<ResponseMessage>(){

            protected boolean matchesSafely(ResponseMessage t) {
                Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(SuccessMessage.class));
                Assert.assertThat(((SuccessMessage)t).meta(), (Matcher)matcher);
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("SUCCESS");
            }
        };
    }

    public static Matcher<ResponseMessage> msgSuccess() {
        return new TypeSafeMatcher<ResponseMessage>(){

            protected boolean matchesSafely(ResponseMessage t) {
                Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(SuccessMessage.class));
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("SUCCESS");
            }
        };
    }

    public static Matcher<ResponseMessage> msgIgnored() {
        return new TypeSafeMatcher<ResponseMessage>(){

            protected boolean matchesSafely(ResponseMessage t) {
                Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(IgnoredMessage.class));
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("IGNORED");
            }
        };
    }

    public static Matcher<ResponseMessage> msgFailure(final Status status, final String message) {
        return new TypeSafeMatcher<ResponseMessage>(){

            protected boolean matchesSafely(ResponseMessage t) {
                Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(FailureMessage.class));
                FailureMessage msg = (FailureMessage)t;
                Assert.assertThat((Object)msg.status(), (Matcher)CoreMatchers.equalTo((Object)status));
                Assert.assertThat((Object)msg.message(), (Matcher)CoreMatchers.containsString((String)message));
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("FAILURE");
            }
        };
    }

    public static Matcher<ResponseMessage> msgRecord(final Matcher<Record> matcher) {
        return new TypeSafeMatcher<ResponseMessage>(){

            protected boolean matchesSafely(ResponseMessage t) {
                Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(RecordMessage.class));
                RecordMessage msg = (RecordMessage)t;
                Assert.assertThat((Object)msg.record(), (Matcher)matcher);
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("RECORD ");
                description.appendDescriptionOf((SelfDescribing)matcher);
            }
        };
    }

    public static byte[] serialize(RequestMessage ... messages) throws IOException {
        RecordingByteChannel rawData = new RecordingByteChannel();
        BoltRequestMessageWriter packer = new BoltRequestMessageWriter(new Neo4jPack.Packer((PackOutput)new BufferedChannelOutput(rawData)), BoltResponseMessageWriter.NO_BOUNDARY_HOOK);
        for (RequestMessage message : messages) {
            packer.write(message);
        }
        packer.flush();
        return rawData.getBytes();
    }

    public static byte[] serialize(ResponseMessage ... messages) throws IOException {
        RecordingByteChannel rawData = new RecordingByteChannel();
        BoltResponseMessageWriter packer = new BoltResponseMessageWriter(new Neo4jPack.Packer((PackOutput)new BufferedChannelOutput(rawData)), BoltResponseMessageWriter.NO_BOUNDARY_HOOK);
        for (ResponseMessage message : messages) {
            message.dispatch(packer);
        }
        packer.flush();
        return rawData.getBytes();
    }

    public static List<RequestMessage> messages(byte[] bytes) throws IOException {
        BoltRequestMessageReader unpacker = MessageMatchers.requestReader(bytes);
        BoltRequestMessageRecorder consumer = new BoltRequestMessageRecorder();
        try {
            while (unpacker.hasNext()) {
                unpacker.read((BoltRequestMessageHandler)consumer);
            }
            return consumer.asList();
        }
        catch (Throwable e) {
            throw new IOException("Failed to deserialize response, '" + e.getMessage() + "'. Messages read so far: \n" + consumer.asList() + "\nRaw data: \n" + HexPrinter.hex((byte[])bytes));
        }
    }

    public static ResponseMessage responseMessage(byte[] bytes) throws IOException {
        BoltResponseMessageReader unpacker = MessageMatchers.responseReader(bytes);
        BoltResponseMessageRecorder consumer = new BoltResponseMessageRecorder();
        try {
            if (unpacker.hasNext()) {
                unpacker.read(consumer);
                return (ResponseMessage)consumer.asList().get(0);
            }
            throw new IllegalArgumentException("Expected a message in `" + HexPrinter.hex((byte[])bytes) + "`");
        }
        catch (Throwable e) {
            throw new IOException("Failed to deserialize response, '" + e.getMessage() + "'.\nRaw data: \n" + HexPrinter.hex((byte[])bytes), e);
        }
    }

    private static BoltRequestMessageReader requestReader(byte[] bytes) {
        return new BoltRequestMessageReader(new Neo4jPack.Unpacker((PackInput)new BufferedChannelInput(128).reset(new ArrayByteChannel(bytes))));
    }

    private static BoltResponseMessageReader responseReader(byte[] bytes) {
        return new BoltResponseMessageReader(new Neo4jPack.Unpacker((PackInput)new BufferedChannelInput(128).reset(new ArrayByteChannel(bytes))));
    }
}

