/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ArrayByteChannel
implements ReadableByteChannel {
    private final ByteBuffer data;

    public ArrayByteChannel(byte[] bytes) {
        this.data = ByteBuffer.wrap(bytes);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.data.position() == this.data.limit()) {
            return -1;
        }
        int originalPosition = this.data.position();
        int originalLimit = this.data.limit();
        this.data.limit(Math.min(this.data.limit(), dst.limit() - dst.position() + this.data.position()));
        dst.put(this.data);
        this.data.limit(originalLimit);
        return this.data.position() - originalPosition;
    }

    @Override
    public boolean isOpen() {
        return this.data.position() < this.data.limit();
    }

    @Override
    public void close() throws IOException {
    }
}

